/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.reader.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import org.jboss.weld.interceptor.reader.ClassMetadataInterceptorReference;
import org.jboss.weld.interceptor.reader.InterceptorMetadataUtils;
import org.jboss.weld.interceptor.reader.ReflectiveClassMetadata;
import org.jboss.weld.interceptor.reader.cache.MetadataCachingReader;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorReference;
import org.jboss.weld.util.cache.LoadingCacheUtils;

public class DefaultMetadataCachingReader
implements MetadataCachingReader {
    private final LoadingCache<InterceptorReference<?>, InterceptorMetadata<?>> interceptorMetadataCache = CacheBuilder.newBuilder().build(new CacheLoader<InterceptorReference<?>, InterceptorMetadata<?>>(){

        public InterceptorMetadata<?> load(InterceptorReference<?> from) {
            return InterceptorMetadataUtils.readMetadataForInterceptorClass(from);
        }
    });
    private final LoadingCache<ClassMetadata<?>, InterceptorMetadata<?>> classMetadataInterceptorMetadataCache = CacheBuilder.newBuilder().build(new CacheLoader<ClassMetadata<?>, InterceptorMetadata<?>>(){

        public InterceptorMetadata<?> load(ClassMetadata<?> from) {
            return InterceptorMetadataUtils.readMetadataForTargetClass(from);
        }
    });
    private final LoadingCache<Class<?>, ClassMetadata<?>> reflectiveClassMetadataCache = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, ClassMetadata<?>>(){

        public ClassMetadata<?> load(Class<?> from) {
            return ReflectiveClassMetadata.of(from);
        }
    });

    @Override
    public <T> InterceptorMetadata<T> getInterceptorMetadata(InterceptorReference<T> interceptorReference) {
        return (InterceptorMetadata)LoadingCacheUtils.getCastCacheValue(this.interceptorMetadataCache, interceptorReference);
    }

    @Override
    public <T> InterceptorMetadata<T> getTargetClassInterceptorMetadata(ClassMetadata<T> classMetadata) {
        return (InterceptorMetadata)LoadingCacheUtils.getCastCacheValue(this.classMetadataInterceptorMetadataCache, classMetadata);
    }

    @Override
    public <T> InterceptorMetadata<T> getInterceptorMetadata(Class<T> clazz) {
        return (InterceptorMetadata)LoadingCacheUtils.getCastCacheValue(this.interceptorMetadataCache, ClassMetadataInterceptorReference.of(LoadingCacheUtils.getCacheValue(this.reflectiveClassMetadataCache, clazz)));
    }

    @Override
    public <T> ClassMetadata<T> getClassMetadata(Class<T> clazz) {
        return (ClassMetadata)LoadingCacheUtils.getCastCacheValue(this.reflectiveClassMetadataCache, clazz);
    }
}

