/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.io.FileUtils;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.BasicFileAttributesImpl;
import org.uberfire.java.nio.base.ExtendedAttributeView;
import org.uberfire.java.nio.base.GeneralPathImpl;
import org.uberfire.java.nio.base.SeekableByteChannelFileBasedImpl;
import org.uberfire.java.nio.channels.AsynchronousFileChannel;
import org.uberfire.java.nio.channels.SeekableByteChannel;
import org.uberfire.java.nio.file.AccessDeniedException;
import org.uberfire.java.nio.file.AccessMode;
import org.uberfire.java.nio.file.AtomicMoveNotSupportedException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.DirectoryNotEmptyException;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.NotDirectoryException;
import org.uberfire.java.nio.file.NotLinkException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardDeleteOption;
import org.uberfire.java.nio.file.StandardOpenOption;
import org.uberfire.java.nio.file.attribute.AttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributeView;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.attribute.FileAttribute;
import org.uberfire.java.nio.file.attribute.FileAttributeView;
import org.uberfire.java.nio.file.spi.FileSystemProvider;
import org.uberfire.java.nio.fs.file.BaseSimpleFileSystem;
import org.uberfire.java.nio.fs.file.SimpleBasicFileAttributeView;
import org.uberfire.java.nio.fs.file.SimpleUnixFileStore;
import org.uberfire.java.nio.fs.file.SimpleUnixFileSystem;
import org.uberfire.java.nio.fs.file.SimpleWindowsFileStore;
import org.uberfire.java.nio.fs.file.SimpleWindowsFileSystem;

public class SimpleFileSystemProvider
implements FileSystemProvider {
    private static final String USER_DIR = "user.dir";
    private final BaseSimpleFileSystem fileSystem;
    private final OSType osType;
    private final File[] roots;
    private boolean isDefault;

    public SimpleFileSystemProvider() {
        this(File.listRoots(), OSType.currentOS());
    }

    SimpleFileSystemProvider(File[] roots, OSType osType) {
        String defaultPath = System.getProperty(USER_DIR);
        this.osType = (OSType)((Object)Preconditions.checkNotNull((String)"osType", (Object)((Object)osType)));
        this.roots = (File[])Preconditions.checkNotNull((String)"roots", (Object)roots);
        this.fileSystem = osType == OSType.WINDOWS ? new SimpleWindowsFileSystem(this, defaultPath) : new SimpleUnixFileSystem(this, defaultPath);
    }

    public synchronized void forceAsDefault() {
        this.isDefault = true;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getScheme() {
        return "file";
    }

    public FileSystem getFileSystem(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        return this.getDefaultFileSystem();
    }

    public Path getPath(URI uri) throws IllegalArgumentException, FileSystemNotFoundException, SecurityException {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        Preconditions.checkCondition((String)"uri scheme not supported", (uri.getScheme().equals(this.getScheme()) || uri.getScheme().equals("default") ? 1 : 0) != 0);
        return this.getDefaultFileSystem().getPath(uri.getPath(), new String[0]);
    }

    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IllegalArgumentException, IOException, SecurityException, FileSystemAlreadyExistsException {
        Preconditions.checkNotNull((String)"uri", (Object)uri);
        Preconditions.checkNotNull((String)"env", env);
        throw new FileSystemAlreadyExistsException(uri.toString());
    }

    public FileSystem newFileSystem(Path path, Map<String, ?> env) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"env", env);
        throw new FileSystemAlreadyExistsException(path.toString());
    }

    public InputStream newInputStream(Path path, OpenOption ... options) throws IllegalArgumentException, NoSuchFileException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        File file = path.toFile();
        if (!file.exists()) {
            throw new NoSuchFileException(file.toString());
        }
        try {
            return new FileInputStream(path.toFile());
        }
        catch (FileNotFoundException e) {
            throw new NoSuchFileException(e.getMessage());
        }
    }

    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        try {
            return new FileOutputStream(path.toFile());
        }
        catch (Exception e) {
            throw new IOException("Could not open output stream.", e);
        }
    }

    public FileChannel newFileChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        return ((FileOutputStream)this.newOutputStream(path, new OpenOption[0])).getChannel();
    }

    public AsynchronousFileChannel newAsynchronousFileChannel(Path path, Set<? extends OpenOption> options, ExecutorService executor, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        throw new UnsupportedOperationException();
    }

    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IllegalArgumentException, UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        File file = ((Path)Preconditions.checkNotNull((String)"path", (Object)path)).toFile();
        if (file.exists() && !this.shouldCreateOrOpenAByteChannel(options)) {
            throw new FileAlreadyExistsException(path.toString());
        }
        try {
            if (options != null && options.contains(StandardOpenOption.READ)) {
                return this.openAByteChannel(path);
            }
            return this.createANewByteChannel(file);
        }
        catch (java.io.IOException e) {
            throw new IOException("Failed to open or create a byte channel.", (Exception)e);
        }
    }

    private SeekableByteChannelFileBasedImpl createANewByteChannel(File file) throws FileNotFoundException {
        return new SeekableByteChannelFileBasedImpl(new RandomAccessFile(file, "rw").getChannel()){

            public void close() throws java.io.IOException {
                super.close();
            }
        };
    }

    private SeekableByteChannelFileBasedImpl openAByteChannel(Path path) throws FileNotFoundException {
        return new SeekableByteChannelFileBasedImpl(new RandomAccessFile(path.toFile(), "r").getChannel());
    }

    private boolean shouldCreateOrOpenAByteChannel(Set<? extends OpenOption> options) {
        return options != null && (options.contains(StandardOpenOption.TRUNCATE_EXISTING) || options.contains(StandardOpenOption.READ));
    }

    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"dir", (Object)dir);
        Path realDir = dir.toAbsolutePath();
        if (realDir.toFile().exists()) {
            throw new FileAlreadyExistsException(dir.toString());
        }
        realDir.toFile().mkdirs();
    }

    public DirectoryStream<Path> newDirectoryStream(Path dir, final DirectoryStream.Filter<Path> filter) throws NotDirectoryException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"filter", filter);
        File file = ((Path)Preconditions.checkNotNull((String)"dir", (Object)dir)).toFile();
        if (!file.isDirectory()) {
            throw new NotDirectoryException(dir.toString());
        }
        final File[] content = file.listFiles();
        if (content == null) {
            throw new NotDirectoryException(dir.toString());
        }
        return new DirectoryStream<Path>(){
            boolean isClosed = false;

            public void close() throws IOException {
                if (this.isClosed) {
                    throw new IOException("This stream is closed.");
                }
                this.isClosed = true;
            }

            public Iterator<Path> iterator() {
                if (this.isClosed) {
                    throw new IOException("This stream is closed.");
                }
                return new Iterator<Path>(){
                    public boolean atEof = false;
                    private int i = -1;
                    private Path nextEntry = null;

                    @Override
                    public boolean hasNext() {
                        if (this.nextEntry == null && !this.atEof) {
                            this.nextEntry = this.readNextEntry();
                        }
                        return this.nextEntry != null;
                    }

                    @Override
                    public Path next() {
                        Path result;
                        if (this.nextEntry == null && !this.atEof) {
                            result = this.readNextEntry();
                        } else {
                            result = this.nextEntry;
                            this.nextEntry = null;
                        }
                        if (result == null) {
                            throw new NoSuchElementException();
                        }
                        return result;
                    }

                    private Path readNextEntry() {
                        GeneralPathImpl result;
                        block2: {
                            GeneralPathImpl path;
                            if (this.atEof) {
                                return null;
                            }
                            result = null;
                            do {
                                ++this.i;
                                if (this.i < content.length) continue;
                                this.atEof = true;
                                break block2;
                            } while (!filter.accept((Object)(path = GeneralPathImpl.newFromFile((FileSystem)SimpleFileSystemProvider.this.getDefaultFileSystem(), (File)content[this.i]))));
                            result = path;
                        }
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"link", (Object)link);
        Preconditions.checkNotNull((String)"target", (Object)target);
        Preconditions.checkCondition((String)"link and target can't be same", (!link.equals(target) ? 1 : 0) != 0);
        Preconditions.checkCondition((String)"target must already exists", (boolean)target.toFile().exists());
        if (link.toFile().exists()) {
            throw new FileAlreadyExistsException(link.toString());
        }
        throw new UnsupportedOperationException();
    }

    public void createLink(Path link, Path existing) throws UnsupportedOperationException, FileAlreadyExistsException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"link", (Object)link);
        Preconditions.checkNotNull((String)"existing", (Object)existing);
        Preconditions.checkCondition((String)"existing must already exists", (boolean)existing.toFile().exists());
        Preconditions.checkCondition((String)"link and target can't be same", (!link.equals(existing) ? 1 : 0) != 0);
        if (link.toFile().exists()) {
            throw new FileAlreadyExistsException(link.toString());
        }
        throw new UnsupportedOperationException();
    }

    public void delete(Path path, DeleteOption ... options) throws NoSuchFileException, DirectoryNotEmptyException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        if (!path.toFile().exists()) {
            throw new NoSuchFileException(path.toString());
        }
        this.deleteIfExists(path, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteIfExists(Path path, DeleteOption ... options) throws DirectoryNotEmptyException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        SimpleFileSystemProvider simpleFileSystemProvider = this;
        synchronized (simpleFileSystemProvider) {
            boolean bl;
            File file = path.toFile();
            try {
                if (file.isDirectory() && !this.deleteNonEmptyDirectory(options) && file.list().length > 0) {
                    throw new DirectoryNotEmptyException(path.toString());
                }
                boolean result = file.exists();
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (java.io.IOException e) {
                    throw new IOException((Exception)e);
                }
                bl = result;
            }
            catch (Throwable throwable) {
                this.toGeneralPathImpl(path).clearCache();
                throw throwable;
            }
            this.toGeneralPathImpl(path).clearCache();
            return bl;
        }
    }

    private boolean deleteNonEmptyDirectory(DeleteOption ... options) {
        for (DeleteOption option : options) {
            if (!option.equals(StandardDeleteOption.NON_EMPTY_DIRECTORIES)) continue;
            return true;
        }
        return false;
    }

    public Path readSymbolicLink(Path link) throws UnsupportedOperationException, NotLinkException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"link", (Object)link);
        if (!link.toFile().exists()) {
            throw new NotLinkException(link.toString());
        }
        throw new UnsupportedOperationException();
    }

    public boolean isSameFile(Path path, Path path2) throws IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"path2", (Object)path2);
        return path.equals(path2);
    }

    public boolean isHidden(Path path) throws IllegalArgumentException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        return path.toFile().isHidden();
    }

    public void checkAccess(Path path, AccessMode ... modes) throws UnsupportedOperationException, NoSuchFileException, AccessDeniedException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"modes", (Object)modes);
        if (!path.toFile().exists()) {
            throw new NoSuchFileException(path.toString());
        }
        if (path.toFile() != null) {
            block5: for (AccessMode mode : modes) {
                Preconditions.checkNotNull((String)"mode", (Object)mode);
                switch (mode) {
                    case READ: {
                        if (path.toFile().canRead()) continue block5;
                        throw new AccessDeniedException(path.toString());
                    }
                    case EXECUTE: {
                        if (path.toFile().canExecute()) continue block5;
                        throw new AccessDeniedException(path.toString());
                    }
                    case WRITE: {
                        if (path.toFile().canWrite()) continue block5;
                        throw new AccessDeniedException(path.toString());
                    }
                }
            }
        }
    }

    public FileStore getFileStore(Path path) throws IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        if (this.osType == OSType.WINDOWS) {
            return new SimpleWindowsFileStore(this.roots, path);
        }
        return new SimpleUnixFileStore(path);
    }

    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) throws NoSuchFileException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"type", type);
        if (!path.toFile().exists()) {
            throw new NoSuchFileException(path.toString());
        }
        GeneralPathImpl gPath = this.toGeneralPathImpl(path);
        FileAttributeView view = (FileAttributeView)gPath.getAttrView(type);
        if (view == null && type == BasicFileAttributeView.class || type == SimpleBasicFileAttributeView.class) {
            SimpleBasicFileAttributeView newView = new SimpleBasicFileAttributeView((Path)gPath);
            gPath.addAttrView((AttributeView)newView);
            return (V)((Object)newView);
        }
        return (V)view;
    }

    private ExtendedAttributeView getFileAttributeView(Path path, String name, LinkOption ... options) {
        GeneralPathImpl gPath = this.toGeneralPathImpl(path);
        ExtendedAttributeView view = (ExtendedAttributeView)gPath.getAttrView(name);
        if (view == null && name.equals("basic")) {
            SimpleBasicFileAttributeView newView = new SimpleBasicFileAttributeView((Path)gPath);
            gPath.addAttrView((AttributeView)newView);
            return newView;
        }
        return view;
    }

    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws NoSuchFileException, UnsupportedOperationException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotNull((String)"type", type);
        if (!path.toFile().exists()) {
            throw new NoSuchFileException(path.toString());
        }
        if (type == BasicFileAttributesImpl.class || type == BasicFileAttributes.class) {
            SimpleBasicFileAttributeView view = this.getFileAttributeView(path, SimpleBasicFileAttributeView.class, options);
            return (A)view.readAttributes();
        }
        return null;
    }

    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotEmpty((String)"attributes", (String)attributes);
        String[] s = this.split(attributes);
        if (s[0].length() == 0) {
            throw new IllegalArgumentException(attributes);
        }
        ExtendedAttributeView view = this.getFileAttributeView(path, s[0], options);
        if (view == null) {
            throw new UnsupportedOperationException("View '" + s[0] + "' not available");
        }
        return view.readAttributes(s[1].split(","));
    }

    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws UnsupportedOperationException, IllegalArgumentException, ClassCastException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"path", (Object)path);
        Preconditions.checkNotEmpty((String)"attributes", (String)attribute);
        String[] s = this.split(attribute);
        if (s[0].length() == 0) {
            throw new IllegalArgumentException(attribute);
        }
        ExtendedAttributeView view = this.getFileAttributeView(path, s[0], options);
        if (view == null) {
            throw new UnsupportedOperationException("View '" + s[0] + "' not available");
        }
        view.setAttribute(attribute, value);
    }

    public void copy(Path source, Path target, CopyOption ... options) throws UnsupportedOperationException, FileAlreadyExistsException, DirectoryNotEmptyException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"source", (Object)source);
        Preconditions.checkNotNull((String)"target", (Object)target);
        Preconditions.checkCondition((String)"source must exist", (boolean)source.toFile().exists());
        if (target.toFile().exists()) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (source.toFile().isDirectory() && source.toFile().list().length > 0) {
            throw new DirectoryNotEmptyException(source.toString());
        }
        try {
            if (source.toFile().isDirectory()) {
                FileUtils.copyDirectory((File)source.toFile(), (File)target.toFile());
            } else {
                FileUtils.copyFile((File)source.toFile(), (File)target.toFile());
            }
        }
        catch (java.io.IOException ex) {
            throw new IOException((Exception)ex);
        }
    }

    public void move(Path source, Path target, CopyOption ... options) throws DirectoryNotEmptyException, AtomicMoveNotSupportedException, IOException, SecurityException {
        Preconditions.checkNotNull((String)"source", (Object)source);
        Preconditions.checkNotNull((String)"target", (Object)target);
        Preconditions.checkCondition((String)"source must exist", (boolean)source.toFile().exists());
        if (target.toFile().exists()) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (source.toFile().isDirectory() && source.toFile().list().length > 0) {
            throw new DirectoryNotEmptyException(source.toString());
        }
        try {
            if (source.toFile().isDirectory()) {
                FileUtils.moveDirectory((File)source.toFile(), (File)target.toFile());
            } else {
                FileUtils.moveFile((File)source.toFile(), (File)target.toFile());
            }
        }
        catch (java.io.IOException ex) {
            throw new IOException((Exception)ex);
        }
    }

    private FileSystem getDefaultFileSystem() {
        return this.fileSystem;
    }

    private GeneralPathImpl toGeneralPathImpl(Path path) {
        if (path instanceof GeneralPathImpl) {
            return (GeneralPathImpl)path;
        }
        return GeneralPathImpl.create((FileSystem)this.fileSystem, (String)path.toString(), (boolean)false);
    }

    private String[] split(String attribute) {
        String[] s = new String[2];
        int pos = attribute.indexOf(58);
        if (pos == -1) {
            s[0] = "basic";
            s[1] = attribute;
        } else {
            s[0] = attribute.substring(0, pos);
            s[1] = pos == attribute.length() ? "" : attribute.substring(pos + 1);
        }
        return s;
    }

    static enum OSType {
        WINDOWS,
        UNIX_LIKE;


        public static OSType currentOS() {
            if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
                return WINDOWS;
            }
            return UNIX_LIKE;
        }
    }
}

