/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.builder;

import java.util.HashMap;
import java.util.Map;
import org.drools.definition.process.Node;
import org.jbpm.process.builder.ActionNodeBuilder;
import org.jbpm.process.builder.EventBasedNodeBuilder;
import org.jbpm.process.builder.ExtendedNodeBuilder;
import org.jbpm.process.builder.MultiConditionalSequenceFlowNodeBuilder;
import org.jbpm.process.builder.ProcessNodeBuilder;
import org.jbpm.process.builder.SplitNodeBuilder;
import org.jbpm.process.builder.WorkItemNodeBuilder;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.FaultNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.Split;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.SubProcessNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.core.node.WorkItemNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessNodeBuilderRegistry {
    public static ProcessNodeBuilderRegistry INSTANCE = new ProcessNodeBuilderRegistry();
    private Map<Class<? extends Node>, ProcessNodeBuilder> registry = new HashMap<Class<? extends Node>, ProcessNodeBuilder>();

    public ProcessNodeBuilderRegistry() {
        this.register(StartNode.class, new ExtendedNodeBuilder());
        this.register(EndNode.class, new ExtendedNodeBuilder());
        this.register(MilestoneNode.class, new EventBasedNodeBuilder());
        this.register(RuleSetNode.class, new EventBasedNodeBuilder());
        this.register(SubProcessNode.class, new EventBasedNodeBuilder());
        this.register(HumanTaskNode.class, new WorkItemNodeBuilder());
        this.register(WorkItemNode.class, new WorkItemNodeBuilder());
        this.register(FaultNode.class, new ExtendedNodeBuilder());
        this.register(TimerNode.class, new ExtendedNodeBuilder());
        this.register(ActionNode.class, new ActionNodeBuilder());
        this.register(Split.class, new SplitNodeBuilder());
        this.register(CompositeContextNode.class, new EventBasedNodeBuilder());
        this.register(StateNode.class, new EventBasedNodeBuilder());
        this.register(NodeImpl.class, new MultiConditionalSequenceFlowNodeBuilder());
    }

    public void register(Class<? extends Node> cls, ProcessNodeBuilder builder) {
        this.registry.put(cls, builder);
    }

    public ProcessNodeBuilder getNodeBuilder(Node node) {
        return this.registry.get(node.getClass());
    }

    public ProcessNodeBuilder getNodeBuilder(Class<? extends Node> cls) {
        return this.registry.get(cls);
    }
}

