/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.xml.model.asset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.drools.workbench.jcr2vfsmigration.xml.model.asset.BaseXmlAsset;

public class DataModelAsset
extends BaseXmlAsset {
    private Collection<DataModelObject> dataObjects = new ArrayList<DataModelObject>();

    public DataModelAsset(String name, String format, String lastContributor, String checkinComment, Date lastModified) {
        super(name, format, lastContributor, checkinComment, lastModified);
    }

    public DataModelObject addDataModelObject(String name, String superType) {
        DataObject obj = new DataObject(name, superType);
        this.dataObjects.add(obj);
        return obj;
    }

    public Iterator<DataModelObject> modelObjects() {
        return this.dataObjects.iterator();
    }

    private class ObjectAnnotation
    implements DataObjectAnnotation {
        private String name;
        private String key;
        private String value;

        private ObjectAnnotation(String name, String key, String value) {
            this.name = name;
            this.key = key;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }

    private class ObjectProperty
    implements DataObjectProperty {
        private String name;
        private String type;

        private ObjectProperty(String name, String type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getType() {
            return this.type;
        }
    }

    private class DataObject
    implements DataModelObject {
        private String name;
        private String superType;
        private Collection<DataObjectAnnotation> objectAnnotations;
        private Collection<DataObjectProperty> objectProperties;

        private DataObject(String name, String superType) {
            this.name = name;
            this.superType = superType;
            this.objectAnnotations = new ArrayList<DataObjectAnnotation>();
            this.objectProperties = new ArrayList<DataObjectProperty>();
        }

        @Override
        public void addObjectProperty(String name, String type) {
            this.objectProperties.add(new ObjectProperty(name, type));
        }

        @Override
        public void addObjectAnnotation(String name, String key, String value) {
            this.objectAnnotations.add(new ObjectAnnotation(name, key, value));
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSuperType() {
            return this.superType;
        }

        @Override
        public Iterator<DataObjectProperty> properties() {
            return this.objectProperties.iterator();
        }

        @Override
        public Iterator<DataObjectAnnotation> annotations() {
            return this.objectAnnotations.iterator();
        }
    }

    public static interface DataObjectAnnotation {
        public String getName();

        public String getKey();

        public String getValue();
    }

    public static interface DataObjectProperty {
        public String getName();

        public String getType();
    }

    public static interface DataModelObject {
        public String getName();

        public String getSuperType();

        public void addObjectProperty(String var1, String var2);

        public void addObjectAnnotation(String var1, String var2, String var3);

        public Iterator<DataObjectProperty> properties();

        public Iterator<DataObjectAnnotation> annotations();
    }
}

