/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.BaseEvaluator;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.TimeIntervalParser;
import org.drools.common.EventFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.time.Interval;

public class CoincidesEvaluatorDefinition
implements EvaluatorDefinition {
    protected static final String coincidesOp = "coincides";
    public static Operator COINCIDES;
    public static Operator COINCIDES_NOT;
    private static String[] SUPPORTED_IDS;
    private Map<String, CoincidesEvaluator> cache = Collections.emptyMap();
    private volatile TimeIntervalParser parser = new TimeIntervalParser();

    public CoincidesEvaluatorDefinition() {
        CoincidesEvaluatorDefinition.init();
    }

    static void init() {
        if (Operator.determineOperator(coincidesOp, false) == null) {
            COINCIDES = Operator.addOperatorToRegistry(coincidesOp, false);
            COINCIDES_NOT = Operator.addOperatorToRegistry(coincidesOp, true);
            SUPPORTED_IDS = new String[]{coincidesOp};
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cache = (Map)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.cache);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), null);
    }

    public Evaluator getEvaluator(ValueType type, Operator operator, String parameterText) {
        return this.getEvaluator(type, operator.getOperatorString(), operator.isNegated(), parameterText);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText) {
        return this.getEvaluator(type, operatorId, isNegated, parameterText, EvaluatorDefinition.Target.HANDLE, EvaluatorDefinition.Target.HANDLE);
    }

    public Evaluator getEvaluator(ValueType type, String operatorId, boolean isNegated, String parameterText, EvaluatorDefinition.Target left, EvaluatorDefinition.Target right) {
        String key;
        CoincidesEvaluator eval;
        if (this.cache == Collections.EMPTY_MAP) {
            this.cache = new HashMap<String, CoincidesEvaluator>();
        }
        if ((eval = this.cache.get(key = (Object)((Object)left) + ":" + (Object)((Object)right) + ":" + isNegated + ":" + parameterText)) == null) {
            Long[] params = this.parser.parse(parameterText);
            eval = new CoincidesEvaluator(type, isNegated, params, parameterText, left == EvaluatorDefinition.Target.FACT, right == EvaluatorDefinition.Target.FACT);
            this.cache.put(key, eval);
        }
        return eval;
    }

    public String[] getEvaluatorIds() {
        return SUPPORTED_IDS;
    }

    public boolean isNegatable() {
        return true;
    }

    public EvaluatorDefinition.Target getTarget() {
        return EvaluatorDefinition.Target.BOTH;
    }

    public boolean supportsType(ValueType type) {
        return true;
    }

    public static class CoincidesEvaluator
    extends BaseEvaluator {
        private static final long serialVersionUID = 510L;
        private long startDev;
        private long endDev;
        private String paramText;
        private boolean unwrapLeft;
        private boolean unwrapRight;

        public CoincidesEvaluator() {
            CoincidesEvaluatorDefinition.init();
        }

        public CoincidesEvaluator(ValueType type, boolean isNegated, Long[] parameters, String paramText, boolean unwrapLeft, boolean unwrapRight) {
            super(type, isNegated ? COINCIDES_NOT : COINCIDES);
            CoincidesEvaluatorDefinition.init();
            this.paramText = paramText;
            this.unwrapLeft = unwrapLeft;
            this.unwrapRight = unwrapRight;
            this.setParameters(parameters);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.startDev = in.readLong();
            this.endDev = in.readLong();
            this.unwrapLeft = in.readBoolean();
            this.unwrapRight = in.readBoolean();
            this.paramText = (String)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeLong(this.startDev);
            out.writeLong(this.endDev);
            out.writeBoolean(this.unwrapLeft);
            out.writeBoolean(this.unwrapRight);
            out.writeObject(this.paramText);
        }

        public boolean isTemporal() {
            return true;
        }

        public Interval getInterval() {
            if (this.getOperator().isNegated()) {
                return new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
            }
            return new Interval(0L, 0L);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor, InternalFactHandle object1, FieldValue object2) {
            throw new RuntimeDroolsException("The 'coincides' operator can only be used to compare one event to another, and never to compare to literal constraints.");
        }

        public boolean evaluateCachedRight(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle left) {
            long leftEndTS;
            long leftStartTS;
            if (context.rightNull || context.declaration.getExtractor().isNullValue(workingMemory, left.getObject())) {
                return false;
            }
            long rightStartTS = ((VariableRestriction.TemporalVariableContextEntry)context).startTS;
            long rightEndTS = ((VariableRestriction.TemporalVariableContextEntry)context).endTS;
            if (context.declaration.getExtractor().isSelfReference()) {
                leftStartTS = ((EventFactHandle)left).getStartTimestamp();
                leftEndTS = ((EventFactHandle)left).getEndTimestamp();
            } else {
                leftEndTS = leftStartTS = context.declaration.getExtractor().getLongValue(workingMemory, left.getObject());
            }
            long distStart = Math.abs(rightStartTS - leftStartTS);
            long distEnd = Math.abs(rightEndTS - leftEndTS);
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd <= this.endDev);
        }

        public boolean evaluateCachedLeft(InternalWorkingMemory workingMemory, VariableRestriction.VariableContextEntry context, InternalFactHandle right) {
            long rightEndTS;
            long rightStartTS;
            if (context.leftNull || context.extractor.isNullValue(workingMemory, right.getObject())) {
                return false;
            }
            if (context.extractor.isSelfReference()) {
                rightStartTS = ((EventFactHandle)right).getStartTimestamp();
                rightEndTS = ((EventFactHandle)right).getEndTimestamp();
            } else {
                rightEndTS = rightStartTS = context.extractor.getLongValue(workingMemory, right.getObject());
            }
            long leftStartTS = ((VariableRestriction.TemporalVariableContextEntry)context).startTS;
            long leftEndTS = ((VariableRestriction.TemporalVariableContextEntry)context).endTS;
            long distStart = Math.abs(rightStartTS - leftStartTS);
            long distEnd = Math.abs(rightEndTS - leftEndTS);
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd <= this.endDev);
        }

        public boolean evaluate(InternalWorkingMemory workingMemory, InternalReadAccessor extractor1, InternalFactHandle handle1, InternalReadAccessor extractor2, InternalFactHandle handle2) {
            long leftEndTS;
            long leftStartTS;
            long rightEndTS;
            long rightStartTS;
            if (extractor1.isNullValue(workingMemory, handle1.getObject()) || extractor2.isNullValue(workingMemory, handle2.getObject())) {
                return false;
            }
            if (extractor1.isSelfReference()) {
                rightStartTS = ((EventFactHandle)handle1).getStartTimestamp();
                rightEndTS = ((EventFactHandle)handle1).getEndTimestamp();
            } else {
                rightEndTS = rightStartTS = extractor1.getLongValue(workingMemory, handle1.getObject());
            }
            if (extractor2.isSelfReference()) {
                leftStartTS = ((EventFactHandle)handle2).getStartTimestamp();
                leftEndTS = ((EventFactHandle)handle2).getEndTimestamp();
            } else {
                leftEndTS = leftStartTS = extractor2.getLongValue(workingMemory, handle2.getObject());
            }
            long distStart = Math.abs(rightStartTS - leftStartTS);
            long distEnd = Math.abs(rightEndTS - leftEndTS);
            return this.getOperator().isNegated() ^ (distStart <= this.startDev && distEnd <= this.endDev);
        }

        public String toString() {
            return "coincides[" + this.startDev + ", " + this.endDev + "]";
        }

        public int hashCode() {
            int PRIME = 31;
            int result = super.hashCode();
            result = 31 * result + (int)(this.endDev ^ this.endDev >>> 32);
            result = 31 * result + (int)(this.startDev ^ this.startDev >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CoincidesEvaluator other = (CoincidesEvaluator)obj;
            return this.endDev == other.endDev && this.startDev == other.startDev;
        }

        private void setParameters(Long[] parameters) {
            if (parameters == null || parameters.length == 0) {
                this.startDev = 0L;
                this.endDev = 0L;
                return;
            }
            for (Long param : parameters) {
                if (param >= 0L) continue;
                throw new RuntimeDroolsException("[Coincides Evaluator]: negative values not allowed for temporal distance thresholds: '" + this.paramText + "'");
            }
            if (parameters.length == 1) {
                this.startDev = parameters[0];
                this.endDev = parameters[0];
            } else if (parameters.length == 2) {
                this.startDev = parameters[0];
                this.endDev = parameters[1];
            } else {
                throw new RuntimeDroolsException("[Coincides Evaluator]: Not possible to have more than 2 parameters: '" + this.paramText + "'");
            }
        }
    }
}

