/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.util.EnumSet;
import java.util.Set;
import org.apache.sis.internal.converter.ClassPair;
import org.apache.sis.internal.converter.SystemRegistry;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.resources.Errors;

abstract class SystemConverter<S, T>
extends ClassPair<S, T>
implements ObjectConverter<S, T> {
    private static final long serialVersionUID = -5003169442214901702L;

    SystemConverter(Class<S> clazz, Class<T> clazz2) {
        super(clazz, clazz2);
    }

    @Override
    public final Class<S> getSourceClass() {
        return this.sourceClass;
    }

    @Override
    public final Class<T> getTargetClass() {
        return this.targetClass;
    }

    static Set<FunctionProperty> bijective() {
        return EnumSet.of(FunctionProperty.INJECTIVE, FunctionProperty.SURJECTIVE, FunctionProperty.ORDER_PRESERVING, FunctionProperty.INVERTIBLE);
    }

    @Override
    public ObjectConverter<T, S> inverse() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(Errors.format((short)80));
    }

    @Override
    public final boolean equals(Object object) {
        if (super.equals(object)) {
            Class<?> clazz = object.getClass();
            return clazz == ClassPair.class || clazz == this.getClass();
        }
        return false;
    }

    public ObjectConverter<S, T> unique() {
        SystemConverter systemConverter = SystemRegistry.INSTANCE.findEquals(this);
        return systemConverter != null ? systemConverter : this;
    }

    protected final Object readResolve() {
        return this.unique();
    }

    final String formatErrorMessage(S s) {
        return Errors.format((short)4, s, this.targetClass);
    }
}

