/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.logging.Level;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.IdentifierMapEntry;
import org.apache.sis.internal.jaxb.NonMarshalledAuthority;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.Citations;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.xml.IdentifierMap;
import org.apache.sis.xml.IdentifierSpace;
import org.apache.sis.xml.MarshalContext;
import org.apache.sis.xml.ValueConverter;
import org.apache.sis.xml.XLink;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;

public final class SpecializedIdentifier<T>
implements Identifier,
Serializable {
    private static final long serialVersionUID = -1699757455535495848L;
    private final IdentifierSpace<T> authority;
    T value;

    public SpecializedIdentifier(IdentifierSpace<T> identifierSpace, T t) {
        this.authority = identifierSpace;
        this.value = t;
    }

    static Identifier parse(Citation citation, String string) {
        if (citation instanceof NonMarshalledAuthority) {
            byte by = ((NonMarshalledAuthority)citation).ordinal;
            switch (by) {
                case 0: {
                    return new SpecializedIdentifier<String>(IdentifierSpace.ID, string);
                }
                case 1: {
                    Context context = Context.current();
                    ValueConverter valueConverter = Context.converter(context);
                    try {
                        return new SpecializedIdentifier<UUID>(IdentifierSpace.UUID, valueConverter.toUUID(context, string));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        SpecializedIdentifier.parseFailure(context, string, UUID.class, illegalArgumentException);
                        break;
                    }
                }
                case 2: 
                case 3: {
                    URI uRI;
                    Context context = Context.current();
                    ValueConverter valueConverter = Context.converter(context);
                    try {
                        uRI = valueConverter.toURI((MarshalContext)context, string);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        SpecializedIdentifier.parseFailure(context, string, URI.class, uRISyntaxException);
                        break;
                    }
                    if (by == 2) {
                        return new SpecializedIdentifier<URI>(IdentifierSpace.HREF, uRI);
                    }
                    XLink xLink = new XLink();
                    xLink.setHRef(uRI);
                    return new SpecializedIdentifier<XLink>(IdentifierSpace.XLINK, xLink);
                }
            }
        }
        return new IdentifierMapEntry(citation, string);
    }

    static void parseFailure(Context context, String string, Class<?> clazz, Exception exception) {
        Context.warningOccured(context, Level.WARNING, IdentifierMap.class, "put", exception, Messages.class, (short)5, clazz, string);
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public String getCode() {
        T t = this.value;
        return t != null ? t.toString() : null;
    }

    public int hashCode() {
        return Objects.hashCode(this.value) + 31 * Objects.hashCode(this.authority);
    }

    public boolean equals(Object object) {
        if (object instanceof SpecializedIdentifier) {
            SpecializedIdentifier specializedIdentifier = (SpecializedIdentifier)object;
            return Objects.equals(this.authority, specializedIdentifier.authority) && Objects.equals(this.value, specializedIdentifier.value);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(60).append("Identifier[");
        SpecializedIdentifier.format(stringBuilder, this.authority, this.getCode());
        return stringBuilder.append(']').toString();
    }

    static void format(StringBuilder stringBuilder, Citation citation, String string) {
        boolean bl;
        stringBuilder.append(Citations.getIdentifier(citation, false)).append('=');
        boolean bl2 = bl = string != null && string.indexOf(91) < 0;
        if (bl) {
            stringBuilder.append('\u201c');
        }
        stringBuilder.append(string);
        if (bl) {
            stringBuilder.append('\u201d');
        }
    }
}

