/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class StandardDateFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = 1552761359761440473L;
    public static final String PATTERN = "yyyy-MM-dd'T'HH:mm:ss.S";
    public static final String SHORT_PATTERN = "yyyy-MM-dd";

    public StandardDateFormat(Locale locale) {
        this(locale, TimeZone.getTimeZone("UTC"));
    }

    public StandardDateFormat(Locale locale, TimeZone timeZone) {
        super("UTC".equals(timeZone.getID()) ? "yyyy-MM-dd'T'HH:mm:ss.S'Z'" : PATTERN, locale);
        this.setTimeZone(timeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        Date date = super.parse(string, parsePosition);
        if (date == null) {
            String string2 = this.toPattern();
            if (string2.startsWith(SHORT_PATTERN)) {
                int n = parsePosition.getErrorIndex();
                parsePosition.setErrorIndex(-1);
                this.applyPattern(SHORT_PATTERN);
                try {
                    date = this.parse(string, parsePosition);
                }
                finally {
                    this.applyPattern(string2);
                }
                if (date == null) {
                    parsePosition.setErrorIndex(n);
                }
            }
        } else {
            int n = parsePosition.getIndex();
            if (n < string.length() && string.charAt(n) == 'Z') {
                long l;
                parsePosition.setIndex(n + 1);
                Calendar calendar = this.calendar;
                int n2 = calendar.get(1);
                int n3 = calendar.get(2);
                int n4 = calendar.get(5);
                int n5 = calendar.get(11);
                int n6 = calendar.get(12);
                int n7 = calendar.get(13);
                int n8 = calendar.get(14);
                TimeZone timeZone = calendar.getTimeZone();
                try {
                    calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
                    calendar.set(n2, n3, n4, n5, n6, n7);
                    calendar.set(14, n8);
                    l = calendar.getTimeInMillis();
                }
                finally {
                    calendar.setTimeZone(timeZone);
                }
                date.setTime(l);
            }
        }
        return date;
    }
}

