/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.setup;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.collection.TreeTables;
import org.apache.sis.util.logging.LoggerFactory;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;

public enum About {
    VERSIONS(63),
    LOCALIZATION(30),
    LOGGING(31),
    PATHS(46),
    LIBRARIES(27);

    private final short resourceKey;

    private About(short s) {
        this.resourceKey = s;
    }

    public static TreeTable configuration() {
        return About.configuration(EnumSet.allOf(About.class), null, null);
    }

    public static TreeTable configuration(Set<About> set, Locale locale, TimeZone timeZone) {
        ArgumentChecks.ensureNonNull("sections", set);
        Locale locale2 = locale != null ? locale : (locale = Locale.getDefault());
        String string = null;
        String string2 = null;
        Date date = new Date();
        Vocabulary vocabulary = Vocabulary.getResources(locale);
        DefaultTreeTable defaultTreeTable = new DefaultTreeTable(TableColumn.NAME, TableColumn.VALUE_AS_TEXT);
        TreeTable.Node node = defaultTreeTable.getRoot();
        node.setValue(TableColumn.NAME, vocabulary.getString((short)28));
        defaultTreeTable.setRoot(node);
        TreeTable.Node node2 = null;
        About about = VERSIONS;
        int n = 0;
        block21: while (true) {
            Object object;
            DateFormat dateFormat;
            LoggerFactory<?> loggerFactory;
            short s = 0;
            String string3 = null;
            Object object2 = null;
            String[] stringArray = null;
            switch (n) {
                case 0: {
                    if (!set.contains((Object)VERSIONS)) break;
                    string3 = "Apache SIS";
                    object2 = Version.SIS;
                    break;
                }
                case 1: {
                    if (!set.contains((Object)VERSIONS)) break;
                    string3 = "Java";
                    object2 = About.concatenate(System.getProperty("java.version"), System.getProperty("java.vendor"), true);
                    break;
                }
                case 2: {
                    if (!set.contains((Object)VERSIONS)) break;
                    s = 42;
                    object2 = About.concatenate(About.concatenate(System.getProperty("os.name"), System.getProperty("os.version"), false), System.getProperty("os.arch"), true);
                    break;
                }
                case 3: {
                    about = LOCALIZATION;
                    if (!set.contains((Object)LOCALIZATION) || (loggerFactory = Locale.getDefault()) == null) break;
                    s = 29;
                    object2 = ((Locale)((Object)loggerFactory)).getDisplayName(locale);
                    CharSequence charSequence = About.concatenate(About.getCode(locale, false), About.getCode(locale, true), true);
                    if (charSequence == null) break;
                    stringArray = new String[]{vocabulary.getString((short)8, "ISO"), charSequence.toString()};
                    break;
                }
                case 4: {
                    if (!set.contains((Object)LOCALIZATION) || (loggerFactory = TimeZone.getDefault()) == null) break;
                    s = 54;
                    boolean bl = ((TimeZone)((Object)loggerFactory)).inDaylightTime(date);
                    object2 = About.concatenate(((TimeZone)((Object)loggerFactory)).getDisplayName(bl, 1, locale), ((TimeZone)((Object)loggerFactory)).getID(), true);
                    dateFormat = DateFormat.getTimeInstance(3, locale2);
                    dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                    int n2 = ((TimeZone)((Object)loggerFactory)).getOffset(date.getTime());
                    object = About.format(dateFormat, n2, new StringBuffer("UTC "));
                    if ((n2 -= ((TimeZone)((Object)loggerFactory)).getRawOffset()) != 0) {
                        object = About.format(dateFormat, n2, ((StringBuffer)object).append(" (").append(vocabulary.getString((short)13)).append(' ')).append(')');
                    }
                    stringArray = new String[]{vocabulary.getString((short)41), ((StringBuffer)object).toString()};
                    break;
                }
                case 5: {
                    if (!set.contains((Object)LOCALIZATION)) break;
                    s = 10;
                    loggerFactory = DateFormat.getDateTimeInstance(1, 1, locale2);
                    if (timeZone != null) {
                        ((DateFormat)((Object)loggerFactory)).setTimeZone(timeZone);
                    }
                    object2 = ((DateFormat)((Object)loggerFactory)).format(date);
                    break;
                }
                case 6: {
                    if (!set.contains((Object)LOCALIZATION) || (loggerFactory = Charset.defaultCharset()) == null) break;
                    s = 6;
                    object2 = ((Charset)((Object)loggerFactory)).displayName(locale);
                    Set<String> set2 = ((Charset)((Object)loggerFactory)).aliases();
                    if (set2 == null || set2.isEmpty()) break;
                    StringBuilder stringBuilder = new StringBuilder((String)object2);
                    String string4 = " (";
                    for (String string5 : set2) {
                        stringBuilder.append(string4).append(string5);
                        string4 = ", ";
                    }
                    object2 = stringBuilder.append(')');
                    break;
                }
                case 7: {
                    about = LOGGING;
                    if (!set.contains((Object)LOGGING)) break;
                    s = 21;
                    loggerFactory = Logging.getLoggerFactory();
                    object2 = loggerFactory != null ? loggerFactory.getName() : "java.util.logging";
                    break;
                }
                case 8: {
                    about = PATHS;
                    if (!set.contains((Object)PATHS)) break;
                    s = 59;
                    string = System.getProperty("user.home");
                    object2 = string;
                    break;
                }
                case 9: {
                    if (!set.contains((Object)PATHS)) break;
                    s = 11;
                    object2 = System.getProperty("user.dir");
                    break;
                }
                case 10: {
                    if (!set.contains((Object)PATHS)) break;
                    s = 52;
                    object2 = System.getProperty("java.io.tmpdir");
                    break;
                }
                case 11: {
                    if (!set.contains((Object)PATHS)) break;
                    s = 24;
                    string2 = System.getProperty("java.home");
                    object2 = string2;
                    break;
                }
                case 12: {
                    about = LIBRARIES;
                    if (!set.contains((Object)LIBRARIES)) break;
                    s = 23;
                    object2 = About.classpath(System.getProperty("java.ext.dirs"), true);
                    break;
                }
                case 13: {
                    if (!set.contains((Object)LIBRARIES)) break;
                    s = 7;
                    object2 = About.classpath(System.getProperty("java.class.path"), false);
                    break;
                }
                default: {
                    break block21;
                }
            }
            if (object2 != null) {
                if (about != null) {
                    node2 = node.newChild();
                    node2.setValue(TableColumn.NAME, vocabulary.getString(about.resourceKey));
                    about = null;
                }
                if (string3 == null) {
                    string3 = vocabulary.getString(s);
                }
                loggerFactory = node2.newChild();
                loggerFactory.setValue(TableColumn.NAME, string3);
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; i += 2) {
                        dateFormat = stringArray[i + 1];
                        if (dateFormat == null) continue;
                        TreeTable.Node node3 = loggerFactory.newChild();
                        node3.setValue(TableColumn.NAME, stringArray[i]);
                        node3.setValue(TableColumn.VALUE_AS_TEXT, dateFormat);
                    }
                }
                if (!(object2 instanceof Map)) {
                    loggerFactory.setValue(TableColumn.VALUE_AS_TEXT, object2.toString());
                } else {
                    Map map = (Map)object2;
                    int n3 = 0;
                    block24: while (true) {
                        short s2;
                        LoggerFactory<?> loggerFactory2 = null;
                        switch (n3) {
                            case 0: {
                                object = string2;
                                s2 = 24;
                                break;
                            }
                            case 1: {
                                object = string;
                                s2 = 59;
                                break;
                            }
                            case 2: {
                                object = "";
                                s2 = 0;
                                loggerFactory2 = loggerFactory;
                                break;
                            }
                            default: {
                                break block24;
                            }
                        }
                        if (object != null) {
                            File file = ((String)object).isEmpty() ? null : new File((String)object);
                            Iterator iterator = map.entrySet().iterator();
                            while (iterator.hasNext()) {
                                CharSequence charSequence;
                                Map.Entry entry = iterator.next();
                                File file2 = (File)entry.getKey();
                                if (file != null && (file2 = About.relativize(file, file2)) == null) continue;
                                if (loggerFactory2 == null) {
                                    loggerFactory2 = loggerFactory.newChild();
                                    loggerFactory2.setValue(TableColumn.NAME, About.parenthesis(vocabulary.getString(s2)));
                                }
                                if ((charSequence = (CharSequence)entry.getValue()) == null || charSequence.length() == 0) {
                                    charSequence = About.parenthesis(vocabulary.getString(((File)entry.getKey()).isDirectory() ? (short)16 : 58).toLowerCase(locale));
                                }
                                TreeTables.nodeForPath((TreeTable.Node)((Object)loggerFactory2), TableColumn.NAME, file2).setValue(TableColumn.VALUE_AS_TEXT, charSequence);
                                iterator.remove();
                            }
                            if (loggerFactory2 != null) {
                                About.concatenateSingletons((TreeTable.Node)((Object)loggerFactory2), true);
                                About.omitMavenRedundancy((TreeTable.Node)((Object)loggerFactory2));
                            }
                        }
                        ++n3;
                    }
                }
            }
            ++n;
        }
        TreeTables.replaceCharSequences(defaultTreeTable, locale);
        return defaultTreeTable;
    }

    private static Map<File, CharSequence> classpath(String string, boolean bl) {
        LinkedHashMap<File, CharSequence> linkedHashMap = new LinkedHashMap<File, CharSequence>();
        return About.classpath(string, null, bl, linkedHashMap) ? linkedHashMap : null;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean classpath(String string, File file, boolean bl, Map<File, CharSequence> map) {
        void var5_7;
        Object object;
        Object object2;
        Object object3;
        File file2;
        if (string == null) {
            return false;
        }
        boolean bl2 = false;
        for (CharSequence charSequence : CharSequences.split(string, file == null ? File.pathSeparatorChar : (char)' ')) {
            file2 = new File(file, charSequence.toString());
            if (!file2.exists()) continue;
            if (!bl) {
                if (map.containsKey(file2)) continue;
                map.put(file2, null);
                bl2 = true;
                continue;
            }
            object3 = new JARFilter();
            object2 = file2.listFiles((FileFilter)object3);
            if (object2 == null) continue;
            Arrays.sort((Object[])object2);
            object = object2;
            int n = ((Object[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object4 = object[i];
                if (map.containsKey(object4)) continue;
                map.put((File)object4, null);
                bl2 = true;
            }
        }
        if (!bl2) {
            return false;
        }
        Object var5_6 = null;
        for (Map.Entry<File, CharSequence> entry : map.entrySet()) {
            CharSequence charSequence;
            charSequence = entry.getValue();
            if (charSequence != null || !(file2 = entry.getKey()).isFile() || !file2.canRead()) continue;
            try {
                object3 = new JarFile(file2);
                object2 = ((JarFile)object3).getManifest();
                if (object2 != null && (object = ((Manifest)object2).getMainAttributes()) != null) {
                    charSequence = About.concatenate(((Attributes)object).getValue(Attributes.Name.IMPLEMENTATION_TITLE), ((Attributes)object).getValue(Attributes.Name.IMPLEMENTATION_VERSION), false);
                    if (charSequence == null && (charSequence = About.concatenate(((Attributes)object).getValue(Attributes.Name.SPECIFICATION_TITLE), ((Attributes)object).getValue(Attributes.Name.SPECIFICATION_VERSION), false)) == null) {
                        charSequence = "";
                    }
                    entry.setValue(charSequence);
                    if (About.classpath(((Attributes)object).getValue(Attributes.Name.CLASS_PATH), file2.getParentFile(), false, map)) break;
                }
                ((ZipFile)object3).close();
            }
            catch (IOException iOException) {
                if (var5_7 != null) continue;
                IOException iOException2 = iOException;
            }
        }
        if (var5_7 != null) {
            Logging.unexpectedException(Logging.getLogger("org.apache.sis.util"), About.class, "configuration", (Throwable)var5_7);
        }
        return true;
    }

    private static void omitMavenRedundancy(TreeTable.Node node) {
        int n;
        int n2;
        for (TreeTable.Node node2 : node.getChildren()) {
            About.omitMavenRedundancy(node2);
        }
        CharSequence charSequence = node.getValue(TableColumn.NAME);
        int n3 = CharSequences.lastIndexOf(charSequence, File.separatorChar, 0, n2 = charSequence.length());
        if (n3 >= 0 && (n = CharSequences.lastIndexOf(charSequence, File.separatorChar, 0, n3)) >= 0) {
            int n4 = CharSequences.lastIndexOf(charSequence, File.separatorChar, 0, n) + 1;
            StringBuilder stringBuilder = new StringBuilder(n3 - n4).append(charSequence, n4, n3);
            stringBuilder.setCharAt(n - n4, '-');
            if (CharSequences.regionMatches(charSequence, n3 + 1, stringBuilder)) {
                stringBuilder.setLength(0);
                node.setValue(TableColumn.NAME, stringBuilder.append(charSequence, 0, n4).append("(\u2026)").append(charSequence, n3, n2));
            }
        }
    }

    private static TreeTable.Node concatenateSingletons(TreeTable.Node node, boolean bl) {
        List list = (List)node.getChildren();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            list.set(i, About.concatenateSingletons((TreeTable.Node)list.get(i), false));
        }
        if (!bl && n == 1 && node.getValue(TableColumn.VALUE_AS_TEXT) == null) {
            TreeTable.Node node2 = (TreeTable.Node)list.remove(0);
            StringBuilder stringBuilder = new StringBuilder(node.getValue(TableColumn.NAME));
            if (!File.separator.contentEquals(stringBuilder)) {
                stringBuilder.append(File.separatorChar);
            }
            node2.setValue(TableColumn.NAME, stringBuilder.append(node2.getValue(TableColumn.NAME)));
            return node2;
        }
        return node;
    }

    private static CharSequence concatenate(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        if (charSequence != null && charSequence.length() != 0) {
            if (charSequence2 != null && charSequence2.length() != 0) {
                StringBuilder stringBuilder = charSequence instanceof StringBuilder ? (StringBuilder)charSequence : new StringBuilder(charSequence);
                stringBuilder.append(' ');
                if (bl) {
                    stringBuilder.append('(');
                }
                stringBuilder.append(charSequence2);
                if (bl) {
                    stringBuilder.append(')');
                }
                return stringBuilder;
            }
            return charSequence;
        }
        return charSequence2;
    }

    private static CharSequence parenthesis(String string) {
        return new StringBuilder(string.length() + 2).append('(').append(string).append(')');
    }

    private static String getCode(Locale locale, boolean bl) {
        try {
            return bl ? locale.getCountry() : locale.getISO3Language();
        }
        catch (MissingResourceException missingResourceException) {
            Logging.recoverableException(Logging.getLogger("org.apache.sis.util.resources"), About.class, "configuration", missingResourceException);
            return null;
        }
    }

    private static StringBuffer format(Format format, int n, StringBuffer stringBuffer) {
        return format.format(Math.abs(n), stringBuffer.append(n < 0 ? (char)'-' : '+').append(' '), new FieldPosition(0));
    }

    private static File relativize(File file, File file2) {
        File file3 = file2.getParentFile();
        if (file3 == null) {
            return null;
        }
        if (file.equals(file3)) {
            file3 = null;
        } else if ((file3 = About.relativize(file, file3)) == null) {
            return null;
        }
        return new File(file3, file2.getName());
    }

    private static final class JARFilter
    implements FileFilter {
        private JARFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(".jar");
        }
    }
}

