/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.changeset;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.SaveCommand;
import org.drools.guvnor.client.asseteditor.SaveEventListener;
import org.drools.guvnor.client.asseteditor.drools.changeset.NewResourcePopup;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.RuleContentText;
import org.drools.guvnor.client.widgets.RESTUtil;
import org.drools.guvnor.client.widgets.drools.explorer.AssetDownloadLinkUtil;
import org.drools.guvnor.client.widgets.drools.explorer.AssetResourceExplorerWidget;
import org.drools.guvnor.client.widgets.drools.explorer.ExplorerRenderMode;
import org.drools.guvnor.client.widgets.drools.explorer.PackageDisplayMode;
import org.drools.guvnor.client.widgets.drools.explorer.PackageReadyCommand;
import org.drools.guvnor.client.widgets.drools.explorer.PackageResourceExplorerWidget;
import org.drools.guvnor.client.widgets.drools.explorer.ResourceElementReadyCommand;

public class ChangeSetEditor
extends DirtyableComposite
implements EditorWidget,
SaveEventListener {
    private static final String resourceXMLElementTemplate = "<resource {name} {description} source='{source}' type='{type}' />";
    private static ChangeSetEditorBinder uiBinder = (ChangeSetEditorBinder)GWT.create(ChangeSetEditorBinder.class);
    @UiField
    protected TextArea editorArea;
    @UiField
    protected Button btnAssetResource;
    @UiField
    protected Button btnPackageResource;
    @UiField
    protected HorizontalPanel pnlURL;
    private ClientFactory clientFactory;
    private final RuleContentText data;
    private final String assetPackageName;
    private final String assetPackageUUID;
    private final String assetName;
    private final int visibleLines;

    public ChangeSetEditor(Asset a, RuleViewer v, ClientFactory clientFactory, EventBus eventBus) {
        this(a, clientFactory);
    }

    public ChangeSetEditor(Asset a, ClientFactory clientFactory) {
        this(a, clientFactory, -1);
    }

    public ChangeSetEditor(Asset asset, ClientFactory clientFactory, int visibleLines) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.clientFactory = clientFactory;
        this.assetPackageUUID = asset.getMetaData().getModuleUUID();
        this.assetPackageName = asset.getMetaData().getModuleName();
        this.assetName = asset.getName();
        this.data = (RuleContentText)asset.getContent();
        if (this.data.content == null) {
            this.data.content = "Empty!";
        }
        this.visibleLines = visibleLines;
        this.customizeUIElements();
    }

    private void customizeUIElements() {
        this.pnlURL.add(this.createChangeSetLink());
        this.editorArea.setStyleName("default-text-Area");
        this.editorArea.setVisibleLines(this.visibleLines == -1 ? 25 : this.visibleLines);
        this.editorArea.setText(this.data.content);
        this.editorArea.getElement().setAttribute("spellcheck", "false");
        this.editorArea.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ((ChangeSetEditor)ChangeSetEditor.this).data.content = ChangeSetEditor.this.editorArea.getText();
                ChangeSetEditor.this.makeDirty();
            }
        });
        this.editorArea.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 9) {
                    event.preventDefault();
                    event.stopPropagation();
                    int pos = ChangeSetEditor.this.editorArea.getCursorPos();
                    ChangeSetEditor.this.insertText("\t", false);
                    ChangeSetEditor.this.editorArea.setCursorPos(pos + 1);
                    ChangeSetEditor.this.editorArea.cancelKey();
                    ChangeSetEditor.this.editorArea.setFocus(true);
                }
            }
        });
    }

    void insertText(String ins, boolean isSpecialPaste) {
        int p;
        this.editorArea.setFocus(true);
        int i = this.editorArea.getCursorPos();
        String left = this.editorArea.getText().substring(0, i);
        String right = this.editorArea.getText().substring(i, this.editorArea.getText().length());
        int cursorPosition = left.toCharArray().length;
        if (isSpecialPaste && (p = ins.indexOf("|")) > -1) {
            cursorPosition += p;
            ins = ins.replaceAll("\\|", "");
        }
        this.editorArea.setText(left + ins + right);
        this.data.content = this.editorArea.getText();
        this.editorArea.setCursorPos(cursorPosition);
    }

    public void onSave(SaveCommand saveCommand) {
        saveCommand.save();
    }

    public void onAfterSave() {
    }

    @UiHandler(value={"btnPackageResource"})
    public void addNewPackageResource(ClickEvent e) {
        this.addNewResourcePackage(new PackageResourceExplorerWidget(this.assetPackageUUID, this.assetPackageName, this.clientFactory, ExplorerRenderMode.DISPLAY_NAME_AND_DESCRIPTION));
    }

    private void addNewResourcePackage(final PackageResourceExplorerWidget widget) {
        final NewResourcePopup popup = new NewResourcePopup(widget.asWidget());
        popup.addOkButtonClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                try {
                    widget.processSelectedPackage(new PackageReadyCommand(){

                        @Override
                        public void onSuccess(String moduleName, String label, String link, String name, String description) {
                            String resourceXMLElementTemplate;
                            String result = resourceXMLElementTemplate = ChangeSetEditor.resourceXMLElementTemplate;
                            String nameString = "";
                            if (name.length() != 0) {
                                nameString = "name=\"" + name.trim() + "\"";
                            }
                            result = result.replace("{name}", nameString);
                            String descriptionString = "";
                            if (description.length() != 0) {
                                descriptionString = "description=\"" + description.trim() + "\"";
                            }
                            result = result.replace("{description}", descriptionString);
                            result = result.replace("{type}", "PKG");
                            result = result.replace("{source}", link);
                            ChangeSetEditor.this.insertText(result.toString(), false);
                        }

                        @Override
                        public void onFailure(Throwable cause) {
                            ErrorPopup.showMessage((String)cause.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    ErrorPopup.showMessage((String)e.getMessage());
                }
                popup.hide();
            }
        });
        popup.show();
    }

    @UiHandler(value={"btnAssetResource"})
    public void addNewAssetResource(ClickEvent e) {
        this.addNewResource(new AssetResourceExplorerWidget(this.assetPackageUUID, this.assetPackageName, this.clientFactory, AssetFormats.CHANGE_SET_RESOURCE, ExplorerRenderMode.DISPLAY_NAME_AND_DESCRIPTION, PackageDisplayMode.ALL_PACKAGES));
    }

    private void addNewResource(final AssetResourceExplorerWidget widget) {
        final NewResourcePopup popup = new NewResourcePopup(widget.asWidget());
        popup.addOkButtonClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                try {
                    widget.processSelectedResources(new ResourceElementReadyCommand(){

                        @Override
                        public void onSuccess(String packageRef, Asset[] assets, String name, String description) {
                            StringBuilder result = new StringBuilder("");
                            for (int i = 0; i < assets.length; ++i) {
                                Asset asset = assets[i];
                                String partialResult = ChangeSetEditor.resourceXMLElementTemplate;
                                String nameString = "";
                                if (name.length() != 0) {
                                    nameString = assets.length == 1 ? "name=\"" + name.trim() + "\"" : "name=\"" + name.trim() + i + "\"";
                                }
                                partialResult = partialResult.replace("{name}", nameString);
                                String descriptionString = "";
                                if (description.length() != 0) {
                                    descriptionString = "description=\"" + description.trim() + "\"";
                                }
                                partialResult = partialResult.replace("{description}", descriptionString);
                                String type = AssetFormats.convertAssetFormatToResourceType((String)asset.getFormat());
                                if (type == null) {
                                    throw new IllegalArgumentException(Constants.INSTANCE.UnknownResourceFormat(asset.getFormat()));
                                }
                                partialResult = partialResult.replace("{type}", type);
                                partialResult = partialResult.replace("{source}", AssetDownloadLinkUtil.buildDownloadLink(asset, packageRef));
                                result.append(partialResult).append('\n');
                            }
                            ChangeSetEditor.this.insertText(result.toString(), false);
                        }

                        @Override
                        public void onFailure(Throwable cause) {
                            ErrorPopup.showMessage((String)cause.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    ErrorPopup.showMessage((String)e.getMessage());
                }
                popup.hide();
            }
        });
        popup.show();
    }

    private Widget createChangeSetLink() {
        String url = RESTUtil.getRESTBaseURL();
        url = url + "packages/";
        url = url + this.assetPackageName;
        url = url + "/assets/";
        url = url + this.assetName;
        url = url + "/source";
        return new HTML(Constants.INSTANCE.Url() + ":&nbsp;<a href='" + url + "' target='_blank'>" + url + "</a>");
    }

    static interface ChangeSetEditorBinder
    extends UiBinder<Widget, ChangeSetEditor> {
    }
}

