/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.HumanReadable;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CEPLengthParameterTextBox;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.CEPTimeParameterTextBox;
import org.drools.guvnor.client.asseteditor.drools.modeldriven.ui.OperatorSelection;
import org.drools.guvnor.client.common.AbstractRestrictedEntryTextBox;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.OperatorsCss;
import org.drools.guvnor.client.resources.OperatorsResource;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.HasCEPWindow;
import org.drools.ide.common.client.modeldriven.brl.HasParameterizedOperator;

public class CEPWindowOperatorsDropdown
extends Composite
implements HasValueChangeHandlers<OperatorSelection> {
    private static final OperatorsResource resources = (OperatorsResource)GWT.create(OperatorsResource.class);
    private static final OperatorsCss css = resources.operatorsCss();
    private List<String> operators = SuggestionCompletionEngine.getCEPWindowOperators();
    private ListBox box;
    private HorizontalPanel parametersContainer = new HorizontalPanel();
    private HorizontalPanel windowContainer = new HorizontalPanel();
    private boolean isReadOnly = false;
    protected HasCEPWindow hcw;
    private static final String CEP_OPERATOR_PARAMETER_GENERATOR = "org.drools.ide.common.server.util.CEPWindowOperatorParameterDRLBuilder";

    public CEPWindowOperatorsDropdown() {
        this.windowContainer.setStylePrimaryName(css.container());
        this.initWidget((Widget)this.windowContainer);
    }

    public CEPWindowOperatorsDropdown(HasCEPWindow hcw, boolean isReadOnly) {
        this();
        this.isReadOnly = isReadOnly;
        this.setCEPWindow(hcw);
    }

    public void setCEPWindow(HasCEPWindow hcw) {
        this.hcw = hcw;
        this.windowContainer.clear();
        this.windowContainer.add(this.getDropDown());
        this.windowContainer.add(this.getOperatorExtension());
    }

    public int getSelectedIndex() {
        return this.box.getSelectedIndex();
    }

    public String getValue(int index) {
        return this.box.getValue(index);
    }

    private Widget getOperatorExtension() {
        this.parametersContainer.setStylePrimaryName(css.container());
        return this.parametersContainer;
    }

    private void operatorChanged(OperatorSelection selection) {
        this.parametersContainer.clear();
        String operator = selection.getValue();
        if (SuggestionCompletionEngine.isCEPWindowOperatorTime((String)operator)) {
            CEPTimeParameterTextBox txt = new CEPTimeParameterTextBox((HasParameterizedOperator)this.hcw.getWindow(), 1);
            this.initialiseTextBox(txt);
        } else if (SuggestionCompletionEngine.isCEPWindowOperatorLength((String)operator)) {
            CEPLengthParameterTextBox txt = new CEPLengthParameterTextBox((HasParameterizedOperator)this.hcw.getWindow(), 1);
            this.initialiseTextBox(txt);
        } else {
            this.parametersContainer.setVisible(false);
            this.hcw.getWindow().clearParameters();
        }
    }

    private void initialiseTextBox(AbstractRestrictedEntryTextBox txt) {
        String key = String.valueOf(1);
        String value = this.hcw.getWindow().getParameter(key);
        if (value == null) {
            value = "";
            this.hcw.getWindow().setParameter(key, value);
        }
        if (!txt.isValidValue(value, false)) {
            value = "";
            this.hcw.getWindow().setParameter(key, value);
        }
        txt.setText(value);
        txt.setEnabled(!this.isReadOnly);
        this.parametersContainer.add((Widget)txt);
        this.parametersContainer.setVisible(true);
        this.hcw.getWindow().setParameter("org.drools.ide.common.server.util.BRDRLPersistence.operatorParameterGenerator", CEP_OPERATOR_PARAMETER_GENERATOR);
    }

    private Widget getDropDown() {
        String selected = "";
        String selectedText = "";
        this.box = new ListBox();
        this.box.setEnabled(!this.isReadOnly);
        this.box.addItem(Constants.INSTANCE.noCEPWindow(), "");
        for (int i = 0; i < this.operators.size(); ++i) {
            String op = this.operators.get(i);
            this.box.addItem(HumanReadable.getOperatorDisplayName(op), op);
            if (!op.equals(this.hcw.getWindow().getOperator())) continue;
            selected = op;
            selectedText = HumanReadable.getOperatorDisplayName(op);
            this.box.setSelectedIndex(i + 1);
        }
        this.selectItem(this.hcw.getWindow().getOperator());
        final CEPWindowOperatorsDropdown source = this;
        final OperatorSelection selection = new OperatorSelection(selected, selectedText);
        Scheduler.get().scheduleFinally((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                CEPWindowOperatorsDropdown.this.operatorChanged(selection);
                ValueChangeEvent.fire((HasValueChangeHandlers)source, (Object)selection);
            }
        });
        this.box.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String selected = CEPWindowOperatorsDropdown.this.box.getValue(CEPWindowOperatorsDropdown.this.box.getSelectedIndex());
                String selectedText = CEPWindowOperatorsDropdown.this.box.getItemText(CEPWindowOperatorsDropdown.this.box.getSelectedIndex());
                OperatorSelection selection = new OperatorSelection(selected, selectedText);
                CEPWindowOperatorsDropdown.this.operatorChanged(selection);
                ValueChangeEvent.fire((HasValueChangeHandlers)source, (Object)selection);
            }
        });
        return this.box;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<OperatorSelection> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public void selectItem(String operator) {
        String currentOperator = this.box.getValue(this.box.getSelectedIndex());
        if (currentOperator.equals(operator)) {
            return;
        }
        for (int i = 0; i < this.box.getItemCount(); ++i) {
            String op = this.box.getValue(i);
            if (!op.equals(operator)) continue;
            this.box.setSelectedIndex(i);
            break;
        }
        String selected = this.box.getValue(this.box.getSelectedIndex());
        String selectedText = this.box.getItemText(this.box.getSelectedIndex());
        OperatorSelection selection = new OperatorSelection(selected, selectedText);
        this.operatorChanged(selection);
    }
}

