/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.serviceconfig;

import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.util.Preconditions;
import org.drools.guvnor.shared.api.PortableObject;

public class AssetReference
implements PortableObject {
    private static final long serialVersionUID = -4916888574125523558L;
    private String packageRef;
    private String name;
    private String format;
    private String url;
    private String uuid;

    public AssetReference() {
    }

    public AssetReference(AssetReference source) {
        Preconditions.checkNotNull((String)"source", (Object)source);
        this.packageRef = source.packageRef;
        this.name = source.name;
        this.format = source.format;
        this.url = source.url;
        this.uuid = source.uuid;
    }

    public AssetReference(String packageRef, String name, String format, String url, String uuid) {
        this.packageRef = Preconditions.checkNotEmpty((String)"packageRef", (String)packageRef);
        this.name = Preconditions.checkNotEmpty((String)"name", (String)name);
        this.format = Preconditions.checkNotEmpty((String)"format", (String)format);
        this.url = Preconditions.checkNotEmpty((String)"url", (String)url);
        this.uuid = Preconditions.checkNotEmpty((String)"uuid", (String)uuid);
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getPackageRef() {
        return this.packageRef;
    }

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    public String getResourceFormat() {
        String resourceFormat = AssetFormats.convertAssetFormatToResourceType((String)this.format);
        if (resourceFormat != null) {
            return resourceFormat;
        }
        return this.format;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetReference that = (AssetReference)o;
        if (this.format != null ? !this.format.equals(that.format) : that.format != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.packageRef != null ? !this.packageRef.equals(that.packageRef) : that.packageRef != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.uuid != null ? !this.uuid.equals(that.uuid) : that.uuid != null);
    }

    public int hashCode() {
        int result = this.packageRef != null ? this.packageRef.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.format != null ? this.format.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.uuid != null ? this.uuid.hashCode() : 0);
        return result;
    }
}

