/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.serviceconfig;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TabLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.SaveCommand;
import org.drools.guvnor.client.asseteditor.SaveEventListener;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.KBaseConfigPanel;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKBaseConfig;
import org.drools.guvnor.client.asseteditor.drools.serviceconfig.ServiceKSessionConfig;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.ClosableLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.ArtifactDependenciesService;
import org.drools.guvnor.client.rpc.ArtifactDependenciesServiceAsync;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.MavenArtifact;
import org.drools.guvnor.client.widgets.drools.explorer.ArtifactDependenciesExplorerWidget;
import org.drools.guvnor.client.widgets.drools.explorer.ArtifactDependenciesReadyCommand;
import org.drools.guvnor.shared.api.PortableObject;

public class ServiceConfigEditor
extends DirtyableComposite
implements EditorWidget,
SaveEventListener {
    private static ServiceConfigEditorBinder uiBinder = (ServiceConfigEditorBinder)GWT.create(ServiceConfigEditorBinder.class);
    @UiField
    protected Button btnDownloadWar;
    @UiField
    protected Button btnArtifacts;
    @UiField
    protected TabLayoutPanel tabPanel;
    final ArtifactDependenciesServiceAsync mavenArtifactsAsync = (ArtifactDependenciesServiceAsync)GWT.create(ArtifactDependenciesService.class);
    private final Asset asset;
    private final String assetUUID;
    private final String assetName;
    private ServiceConfig config;
    private Collection<MavenArtifact> serviceArtifacts = null;

    public ServiceConfigEditor(Asset a, RuleViewer v, ClientFactory clientFactory, EventBus eventBus) {
        this(a, clientFactory);
    }

    public ServiceConfigEditor(Asset asset, final ClientFactory clientFactory) {
        this.asset = asset;
        this.assetUUID = asset.getUuid();
        this.assetName = asset.getName();
        this.config = (ServiceConfig)asset.getContent();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        for (ServiceKBaseConfig activeKbase : this.config.getKbases()) {
            this.addKBasePainel(activeKbase, clientFactory);
        }
        final HorizontalPanel panel = new HorizontalPanel();
        Anchor linkNewKBase = new Anchor("[+]");
        linkNewKBase.setStyleName("serviceTab");
        panel.add((Widget)linkNewKBase);
        this.tabPanel.add((Widget)new HTML(""), (Widget)panel);
        this.tabPanel.addSelectionHandler((SelectionHandler)new SelectionHandler<Integer>(){

            public void onSelection(SelectionEvent<Integer> integerSelectionEvent) {
                if ((Integer)integerSelectionEvent.getSelectedItem() == ServiceConfigEditor.this.tabPanel.getWidgetCount() - 1) {
                    ServiceKBaseConfig newKbase = new ServiceKBaseConfig(ServiceConfigEditor.this.config.getNextKBaseName());
                    newKbase.addKsession(new ServiceKSessionConfig(newKbase.getNextKSessionName()));
                    ServiceConfigEditor.this.config.addKBase(newKbase);
                    ServiceConfigEditor.this.addKBasePainel(newKbase, clientFactory);
                    ServiceConfigEditor.this.tabPanel.remove(ServiceConfigEditor.this.tabPanel.getWidgetCount() - 2);
                    ServiceConfigEditor.this.tabPanel.add((Widget)new HTML(""), (Widget)panel);
                    ServiceConfigEditor.this.tabPanel.selectTab(ServiceConfigEditor.this.tabPanel.getWidgetCount() - 2);
                }
            }
        });
        this.tabPanel.selectTab(0);
        this.loadContent();
    }

    private void addKBasePainel(final ServiceKBaseConfig kbase, ClientFactory clientFactory) {
        final ClosableLabel closableLabel = new ClosableLabel(kbase.getName());
        UpdateTabEvent updateTabEvent = new UpdateTabEvent(){

            @Override
            public void onUpdate(String newName) {
                closableLabel.updateTitle(newName);
            }
        };
        this.tabPanel.add((Widget)new KBaseConfigPanel(this.config, kbase, updateTabEvent, this.asset.getMetaData().getModuleUUID(), this.asset.getMetaData().getModuleName(), clientFactory), (Widget)closableLabel);
        closableLabel.addCloseHandler((CloseHandler)new CloseHandler<ClosableLabel>(){

            public void onClose(CloseEvent<ClosableLabel> closableLabelCloseEvent) {
                if (ServiceConfigEditor.this.tabPanel.getWidgetCount() <= 2) {
                    Window.alert((String)Constants.INSTANCE.CantDeleteKBase());
                    return;
                }
                if (!Window.confirm((String)Constants.INSTANCE.ConfirmDeleteKBase())) {
                    return;
                }
                for (int i = 0; i < ServiceConfigEditor.this.tabPanel.getWidgetCount(); ++i) {
                    KBaseConfigPanel editor;
                    if (!(ServiceConfigEditor.this.tabPanel.getWidget(i) instanceof KBaseConfigPanel) || !(editor = (KBaseConfigPanel)ServiceConfigEditor.this.tabPanel.getWidget(i)).getKBase().getName().equals(kbase.getName())) continue;
                    ServiceConfigEditor.this.config.removeKBase(kbase.getName());
                    ServiceConfigEditor.this.tabPanel.remove(i);
                    break;
                }
            }
        });
    }

    private void loadContent() {
        this.mavenArtifactsAsync.getDependencies((AsyncCallback)new AsyncCallback<Collection<MavenArtifact>>(){

            public void onFailure(Throwable e) {
                ErrorPopup.showMessage((String)e.getMessage());
            }

            public void onSuccess(Collection<MavenArtifact> result) {
                ServiceConfigEditor.this.serviceArtifacts = new ArrayList<MavenArtifact>(result);
            }
        });
    }

    public void onSave(SaveCommand saveCommand) {
        for (int i = 0; i < this.tabPanel.getWidgetCount(); ++i) {
            if (!(this.tabPanel.getWidget(i) instanceof KBaseConfigPanel)) continue;
            KBaseConfigPanel kbaseEditor = (KBaseConfigPanel)this.tabPanel.getWidget(i);
            kbaseEditor.onSave();
        }
        this.asset.setContent((PortableObject)this.config);
        saveCommand.save();
    }

    public void onAfterSave() {
    }

    @UiHandler(value={"btnArtifacts"})
    public void setupMavenArtifacts(ClickEvent e) {
        final ArtifactDependenciesExplorerWidget widget = new ArtifactDependenciesExplorerWidget(this.assetName, this.serviceArtifacts, this.config.getExcludedArtifacts());
        final InternalPopup popup = new InternalPopup(widget.asWidget(), Constants.INSTANCE.ManageDependenciesEllipsis());
        popup.addOkButtonClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                try {
                    widget.processExcludedArtifacts(new ArtifactDependenciesReadyCommand(){

                        @Override
                        public void onSuccess(Collection<MavenArtifact> excludedItems) {
                            ServiceConfigEditor.this.config.setExcludedArtifacts(excludedItems);
                        }

                        @Override
                        public void onFailure(Throwable cause) {
                            ErrorPopup.showMessage((String)cause.getMessage());
                        }
                    });
                }
                catch (Exception e) {
                    ErrorPopup.showMessage((String)e.getMessage());
                }
                popup.hide();
            }
        });
        popup.show();
    }

    @UiHandler(value={"btnDownloadWar"})
    public void downloadWarFile(ClickEvent e) {
        Window.open((String)(GWT.getModuleBaseURL() + "serviceWarBuilderAndDownloadHandler?uuid=" + this.assetUUID), (String)"service download", (String)"");
    }

    public static interface UpdateTabEvent {
        public void onUpdate(String var1);
    }

    private class InternalPopup
    extends FormStylePopup {
        private final Button ok = new Button(Constants.INSTANCE.OK());

        public InternalPopup(Widget content, String title) {
            this.setTitle(title);
            HorizontalPanel hor = new HorizontalPanel();
            Button cancel = new Button(Constants.INSTANCE.Cancel());
            hor.add((Widget)this.ok);
            hor.add((Widget)cancel);
            this.addRow(content);
            this.addRow((Widget)hor);
            cancel.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    InternalPopup.this.hide();
                }
            });
        }

        public void addOkButtonClickHandler(ClickHandler clickHandler) {
            this.ok.addClickHandler(clickHandler);
        }
    }

    static interface ServiceConfigEditorBinder
    extends UiBinder<Widget, ServiceConfigEditor> {
    }
}

