/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.qa.BulkRunResultView;
import org.drools.guvnor.client.explorer.navigation.qa.SummaryTable;
import org.drools.guvnor.client.explorer.navigation.qa.SummaryTableView;
import org.drools.guvnor.client.explorer.navigation.qa.SummaryTableViewImpl;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.PackageBuilderWidget;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.util.PercentageBar;
import org.drools.guvnor.client.util.ToggleLabel;
import org.drools.guvnor.client.util.ValueList;

public class BulkRunResultViewImpl
extends Composite
implements BulkRunResultView {
    private final ClientFactory clientFactory;
    private static BulkRunResultViewImplBinder uiBinder = (BulkRunResultViewImplBinder)GWT.create(BulkRunResultViewImplBinder.class);
    private BulkRunResultView.Presenter presenter;
    @UiField
    ToggleLabel overAll;
    @UiField
    PercentageBar resultsBar;
    @UiField
    SmallLabel failuresOutOfExpectations;
    @UiField
    PercentageBar coveredPercentBar;
    @UiField
    SmallLabel ruleCoveragePercent;
    @UiField
    ValueList uncoveredRules;
    @UiField(provided=true)
    SummaryTableView summaryTableView = new SummaryTableViewImpl();
    private SummaryTable summaryTable;

    public BulkRunResultViewImpl(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
        this.summaryTable = new SummaryTable(this.summaryTableView, clientFactory);
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
    }

    @UiHandler(value={"closeButton"})
    void close(ClickEvent clickEvent) {
        this.presenter.onClose();
    }

    @Override
    public void showErrors(BuilderResult errors) {
        SimplePanel err = new SimplePanel();
        PackageBuilderWidget.showBuilderErrors(errors, (Panel)err, this.clientFactory);
    }

    @Override
    public void addNormalSummaryTableRow(int totalFailures, int grandTotal, String scenarioName, int percentage, String uuid) {
        SummaryTable.Row row = new SummaryTable.Row();
        row.setMessage(Constants.INSTANCE.TestFailureBulkFailures(totalFailures, grandTotal));
        row.setScenarioName(scenarioName);
        row.setUuid(uuid);
        row.setPercentage(percentage);
        row.setBackgroundColor("WHITE");
        this.summaryTable.addRow(row);
    }

    @Override
    public void addMissingExpectationSummaryTableRow(String scenarioName, String uuid) {
        SummaryTable.Row row = new SummaryTable.Row();
        row.setMessage(Constants.INSTANCE.MissingExpectations());
        row.setScenarioName(scenarioName);
        row.setUuid(uuid);
        row.setPercentage(0);
        row.setBackgroundColor("YELLOW");
        this.summaryTable.addRow(row);
    }

    @Override
    public void setPresenter(BulkRunResultView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setFailed() {
        this.overAll.setValue(Boolean.valueOf(false));
    }

    @Override
    public void setSuccess() {
        this.overAll.setValue(Boolean.valueOf(true));
    }

    @Override
    public void setFailuresOutOfExpectation(int totalFailures, int grandTotal) {
        this.failuresOutOfExpectations.setText(Constants.INSTANCE.failuresOutOFExpectations(totalFailures, grandTotal));
    }

    @Override
    public void setResultsPercent(int i) {
        this.resultsBar.setValue(Integer.valueOf(i));
    }

    @Override
    public void setRulesCoveredPercent(int percentCovered) {
        this.coveredPercentBar.setValue(Integer.valueOf(percentCovered));
        this.ruleCoveragePercent.setText(Constants.INSTANCE.RuleCoveragePercent(percentCovered));
    }

    @Override
    public void addUncoveredRules(String uncoveredRule) {
        this.uncoveredRules.addItem(uncoveredRule);
    }

    static interface BulkRunResultViewImplBinder
    extends UiBinder<Widget, BulkRunResultViewImpl> {
    }
}

