/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.AbstractMetadata;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.PropertyAccessor;
import org.apache.sis.metadata.RecursivityGuard;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.metadata.ValueMap;
import org.apache.sis.util.Emptiable;
import org.opengis.util.CodeList;

final class Pruner {
    private static final RecursivityGuard<Boolean> MAPS = new RecursivityGuard();

    private Pruner() {
    }

    private static Map<String, Object> asMap(MetadataStandard metadataStandard, Object object, boolean bl, boolean bl2) {
        PropertyAccessor propertyAccessor = metadataStandard.getAccessor(object.getClass(), bl);
        if (propertyAccessor != null) {
            return new ValueMap(object, propertyAccessor, KeyNamePolicy.JAVABEANS_PROPERTY, bl2 ? ValueExistencePolicy.NON_NULL : ValueExistencePolicy.NON_EMPTY);
        }
        return null;
    }

    private static boolean isPrimitive(Map.Entry<String, Object> entry) {
        return entry instanceof ValueMap.Property && ((ValueMap.Property)entry).getValueType().isPrimitive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isEmpty(AbstractMetadata abstractMetadata, boolean bl, boolean bl2) {
        Map<String, Object> map = Pruner.asMap(abstractMetadata.getStandard(), abstractMetadata, bl, bl2);
        if (map == null) {
            return false;
        }
        Map map2 = (Map)MAPS.get();
        if (!map2.isEmpty()) {
            return Pruner.isEmpty(map, map2, bl2);
        }
        try {
            map2.put(abstractMetadata, Boolean.FALSE);
            boolean bl3 = Pruner.isEmpty(map, map2, bl2);
            return bl3;
        }
        finally {
            MAPS.remove();
        }
    }

    private static boolean isEmpty(Map<String, Object> map, Map<Object, Boolean> map2, boolean bl) {
        boolean bl2 = true;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object object = entry.getValue();
            Boolean bl3 = map2.put(object, Boolean.FALSE);
            if (bl3 != null) {
                if (bl3.booleanValue()) {
                    map2.put(object, Boolean.TRUE);
                    continue;
                }
                bl2 = false;
                if (bl) continue;
                break;
            }
            boolean bl4 = true;
            Collection<?> collection = CollectionsExt.toCollection(object);
            Iterator<?> iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!ValueExistencePolicy.isNullOrEmpty(obj)) {
                    Object object2;
                    boolean bl5 = false;
                    if (obj instanceof AbstractMetadata) {
                        object2 = (AbstractMetadata)obj;
                        if (bl) {
                            ((AbstractMetadata)object2).prune();
                        }
                        bl5 = ((AbstractMetadata)object2).isEmpty();
                    } else if (!bl && obj instanceof Emptiable) {
                        bl5 = ((Emptiable)obj).isEmpty();
                    } else if (!(obj instanceof Enum) && !(obj instanceof CodeList)) {
                        object2 = MetadataStandard.forClass(obj.getClass());
                        if (object2 != null) {
                            bl5 = Pruner.isEmpty(Pruner.asMap((MetadataStandard)object2, obj, false, bl), map2, bl);
                            if (!bl5 && obj instanceof Emptiable) {
                                bl5 = ((Emptiable)obj).isEmpty();
                            }
                        } else if (Pruner.isPrimitive(entry)) {
                            bl5 = object instanceof Number ? Double.isNaN(((Number)object).doubleValue()) : Boolean.FALSE.equals(object);
                        }
                    }
                    if (!bl5) {
                        if (!bl) {
                            return false;
                        }
                        bl4 = false;
                        continue;
                    }
                }
                if (!bl || collection != object) continue;
                iterator.remove();
            }
            bl2 &= bl4;
            if (!bl4) continue;
            map2.put(object, Boolean.TRUE);
            if (!bl) continue;
            try {
                entry.setValue(null);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        return bl2;
    }
}

