/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.identification.DefaultOperationMetadata;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.util.InternationalString;

@XmlType(name="SV_OperationChainMetadata_Type", namespace="http://www.isotc211.org/2005/srv", propOrder={"name", "description", "operations"})
@XmlRootElement(name="SV_OperationChainMetadata", namespace="http://www.isotc211.org/2005/srv")
@UML(identifier="SV_OperationChainMetadata", specification=Specification.ISO_19115)
public class DefaultOperationChainMetadata
extends ISOMetadata {
    private static final long serialVersionUID = 4132508877114835286L;
    private InternationalString name;
    private InternationalString description;
    private List<DefaultOperationMetadata> operations;

    public DefaultOperationChainMetadata() {
    }

    public DefaultOperationChainMetadata(CharSequence charSequence) {
        this.name = Types.toInternationalString(charSequence);
    }

    public DefaultOperationChainMetadata(DefaultOperationChainMetadata defaultOperationChainMetadata) {
        super(defaultOperationChainMetadata);
        if (defaultOperationChainMetadata != null) {
            this.name = defaultOperationChainMetadata.getName();
            this.description = defaultOperationChainMetadata.getDescription();
            this.operations = this.copyList(defaultOperationChainMetadata.getOperations(), DefaultOperationMetadata.class);
        }
    }

    @XmlElement(name="name", namespace="http://www.isotc211.org/2005/srv", required=true)
    @UML(identifier="name", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public InternationalString getName() {
        return this.name;
    }

    public void setName(InternationalString internationalString) {
        this.checkWritePermission();
        this.name = internationalString;
    }

    @XmlElement(name="description", namespace="http://www.isotc211.org/2005/srv")
    @UML(identifier="description", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @XmlElement(name="operation", namespace="http://www.isotc211.org/2005/srv", required=true)
    @UML(identifier="operation", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public List<DefaultOperationMetadata> getOperations() {
        this.operations = this.nonNullList(this.operations, DefaultOperationMetadata.class);
        return this.operations;
    }

    public void setOperations(List<? extends DefaultOperationMetadata> list) {
        this.operations = this.writeList(list, this.operations, DefaultOperationMetadata.class);
    }
}

