/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;

abstract class ConformalProjection
extends NormalizedProjection {
    private static final long serialVersionUID = 458860570536642265L;
    static final double EXCENTRICITY_THRESHOLD = 0.16;
    private static final boolean ORIGINAL_FORMULA = true;
    private transient double c2\u03c7;
    private transient double c4\u03c7;
    private transient double c6\u03c7;
    private transient double c8\u03c7;
    private transient boolean useIterations;

    ConformalProjection(Initializer initializer) {
        super(initializer);
        this.initialize();
    }

    private void initialize() {
        this.useIterations = this.excentricity >= 0.16;
        double d = this.excentricitySquared;
        double d2 = d * d;
        double d3 = d * d2;
        double d4 = d2 * d2;
        this.c2\u03c7 = 0.03611111111111111 * d4 + 0.08333333333333333 * d3 + 0.20833333333333334 * d2 + d / 2.0;
        this.c4\u03c7 = 0.07039930555555556 * d4 + 0.12083333333333333 * d3 + 0.14583333333333334 * d2;
        this.c6\u03c7 = 0.07232142857142858 * d4 + 0.058333333333333334 * d3;
        this.c8\u03c7 = 0.026531498015873015 * d4;
    }

    ConformalProjection(ConformalProjection conformalProjection) {
        super(conformalProjection);
        this.useIterations = conformalProjection.useIterations;
        this.c2\u03c7 = conformalProjection.c2\u03c7;
        this.c4\u03c7 = conformalProjection.c4\u03c7;
        this.c6\u03c7 = conformalProjection.c6\u03c7;
        this.c8\u03c7 = conformalProjection.c8\u03c7;
    }

    final double \u03c6(double d) throws ProjectionException {
        double d2 = 1.5707963267948966 - 2.0 * Math.atan(d);
        d2 += this.c8\u03c7 * Math.sin(8.0 * d2) + this.c6\u03c7 * Math.sin(6.0 * d2) + this.c4\u03c7 * Math.sin(4.0 * d2) + this.c2\u03c7 * Math.sin(2.0 * d2);
        if (!this.useIterations) {
            return d2;
        }
        double d3 = 0.5 * this.excentricity;
        for (int i = 0; i < 15; ++i) {
            double d4 = this.excentricity * Math.sin(d2);
            double d5 = d2;
            d2 = 1.5707963267948966 - 2.0 * Math.atan(d * Math.pow((1.0 - d4) / (1.0 + d4), d3));
            double d6 = Math.abs(d5 - d2);
            if (!(d6 <= 3.926676682852614E-10)) continue;
            return d2;
        }
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        throw new ProjectionException(181);
    }

    final double expOfNorthing(double d, double d2) {
        return Math.tan(0.7853981633974483 + 0.5 * d) * Math.pow((1.0 - d2) / (1.0 + d2), 0.5 * this.excentricity);
    }

    final double dy_d\u03c6(double d, double d2) {
        return 1.0 / d2 - this.excentricitySquared * d2 / (1.0 - this.excentricitySquared * (d * d));
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize();
    }
}

