/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server.indexing;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.kie.workbench.common.screens.datamodeller.backend.server.indexing.JavaFileIndexerExtension;
import org.kie.workbench.common.screens.datamodeller.backend.server.indexing.JavaSourceVisitor;
import org.kie.workbench.common.screens.javaeditor.type.JavaResourceTypeDefinition;
import org.kie.workbench.common.services.backend.project.ProjectClassLoaderHelper;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.model.index.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.model.index.Resource;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class JavaFileIndexer
extends AbstractFileIndexer {
    private static final Logger logger = LoggerFactory.getLogger(JavaFileIndexer.class);
    @Inject
    protected JavaResourceTypeDefinition javaResourceTypeDefinition;
    @Inject
    @Any
    protected Instance<JavaFileIndexerExtension> javaFileIndexerExtensions;
    @Inject
    ProjectClassLoaderHelper classLoaderHelper;

    public boolean supportsPath(Path path) {
        return this.javaResourceTypeDefinition.accept(Paths.convert((Path)path));
    }

    public DefaultIndexBuilder fillIndexBuilder(Path path) throws Exception {
        KieProject project = this.getProject(path);
        if (project == null) {
            logger.error("Unable to index " + path.toUri().toString() + ": project could not be resolved.");
            return null;
        }
        Package pkg = this.getPackage(path);
        if (pkg == null) {
            logger.error("Unable to index " + path.toUri().toString() + ": package could not be resolved.");
            return null;
        }
        DefaultIndexBuilder builder = new DefaultIndexBuilder((Project)project, pkg);
        String javaSource = this.ioService.readAllString(path);
        JavaType javaType = Roaster.parse((String)javaSource);
        if (javaType.getSyntaxErrors() == null || javaType.getSyntaxErrors().isEmpty()) {
            if (this.javaFileIndexerExtensions != null) {
                for (JavaFileIndexerExtension javaFileIndexerExtension : this.javaFileIndexerExtensions) {
                    javaFileIndexerExtension.process(builder, javaType);
                }
            }
            String pkgName = pkg.getPackageName();
            pkgName = javaType.getPackage();
            if (pkgName == null) {
                pkgName = "";
            }
            builder.setPackageName(pkgName);
            String javaTypeName = javaType.getQualifiedName();
            Resource resParts = new Resource(javaTypeName, ResourceType.JAVA);
            if (javaType instanceof JavaSource) {
                ClassLoader projectClassLoader = this.getProjectClassLoader(project);
                JavaSourceVisitor visitor = new JavaSourceVisitor((JavaSource)javaType, projectClassLoader, resParts);
                visitor.visit((JavaSource)javaType);
                this.addReferencedResourcesToIndexBuilder(builder, visitor);
            }
            builder.addGenerator((IndexElementsGenerator)resParts);
        }
        return builder;
    }

    protected ClassLoader getProjectClassLoader(KieProject project) {
        return this.classLoaderHelper.getProjectClassLoader(project);
    }

    protected KieProject getProject(Path path) {
        return (KieProject)this.projectService.resolveProject(Paths.convert((Path)path));
    }

    protected Package getPackage(Path path) {
        return this.projectService.resolvePackage(Paths.convert((Path)path));
    }
}

