/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositorySearchService;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.bus.server.annotations.Service;

@Service
@ApplicationScoped
public class RepositorySearchServiceImpl
implements RepositorySearchService {
    private RepositoryService repositoryService;

    @Inject
    public RepositorySearchServiceImpl(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public Collection<Repository> searchByAlias(String pattern, int maxItems, boolean caseSensitive) {
        ArrayList<Repository> results = new ArrayList<Repository>();
        for (Repository repo : this.repositoryService.getAllRepositories()) {
            String alias = repo.getAlias();
            if (!(caseSensitive ? alias.contains(pattern) : alias.toLowerCase().contains(pattern.toLowerCase()))) continue;
            results.add(repo);
            if (maxItems <= 0 || results.size() < maxItems) continue;
            return results;
        }
        return results;
    }

    public Collection<Repository> searchById(Collection<String> ids) {
        ArrayList<Repository> results = new ArrayList<Repository>();
        for (Repository repo : this.repositoryService.getAllRepositories()) {
            if (!ids.contains(repo.getIdentifier())) continue;
            results.add(repo);
        }
        return results;
    }
}

