/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.GitMetadataStore;
import org.guvnor.structure.repositories.NewRepositoryEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryAlreadyExistsException;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfiguration;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryInfo;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.server.util.TextUtil;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.version.impl.PortableVersionRecord;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;

@Service
@ApplicationScoped
public class RepositoryServiceImpl
implements RepositoryService {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryServiceImpl.class);
    private static final int HISTORY_PAGE_SIZE = 10;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private GitMetadataStore metadataStore;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private RepositoryFactory repositoryFactory;
    @Inject
    private Event<NewRepositoryEvent> event;
    @Inject
    private Event<RepositoryRemovedEvent> repositoryRemovedEvent;
    @Inject
    private BackwardCompatibleUtil backward;
    @Inject
    private ConfiguredRepositories configuredRepositories;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private SessionInfo sessionInfo;

    private Repository createRepository(ConfigGroup repositoryConfig) {
        Repository repository = this.repositoryFactory.newRepository(repositoryConfig);
        this.configurationService.addConfiguration(repositoryConfig);
        this.configuredRepositories.add(repository);
        return repository;
    }

    public RepositoryInfo getRepositoryInfo(String alias) {
        Repository repo = this.getRepository(alias);
        String ouName = null;
        for (OrganizationalUnit ou : this.organizationalUnitService.getAllOrganizationalUnits()) {
            for (Repository repository : ou.getRepositories()) {
                if (!repository.getAlias().equals(alias)) continue;
                ouName = ou.getName();
            }
        }
        return new RepositoryInfo(repo.getIdentifier(), alias, ouName, repo.getRoot(), repo.getPublicURIs(), this.getRepositoryHistory(alias, 0, 10));
    }

    public List<VersionRecord> getRepositoryHistory(String alias, int startIndex) {
        return this.getRepositoryHistory(alias, startIndex, startIndex + 10);
    }

    public List<VersionRecord> getRepositoryHistory(String alias, int startIndex, int endIndex) {
        Repository repo = this.getRepository(alias);
        if (repo == null) {
            return Collections.EMPTY_LIST;
        }
        VersionAttributeView versionAttributeView = (VersionAttributeView)this.ioService.getFileAttributeView(Paths.convert((Path)repo.getRoot()), VersionAttributeView.class);
        List records = versionAttributeView.readAttributes().history().records();
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex < 0 || endIndex > records.size()) {
            endIndex = records.size();
        }
        if (startIndex >= records.size() || startIndex >= endIndex) {
            return Collections.emptyList();
        }
        Collections.reverse(records);
        ArrayList<VersionRecord> result = new ArrayList<VersionRecord>(endIndex - startIndex);
        for (VersionRecord record : records.subList(startIndex, endIndex)) {
            result.add((VersionRecord)new PortableVersionRecord(record.id(), record.author(), record.email(), record.comment(), record.date(), record.uri()));
        }
        return result;
    }

    public Repository getRepository(String alias) {
        return this.configuredRepositories.getRepositoryByRepositoryAlias(alias);
    }

    public Repository getRepository(Path root) {
        return this.configuredRepositories.getRepositoryByRootPath(root);
    }

    public String normalizeRepositoryName(String name) {
        return TextUtil.normalizeRepositoryName((String)name);
    }

    public boolean validateRepositoryName(String name) {
        return name != null && !"".equals(name) && name.equals(this.normalizeRepositoryName(name));
    }

    public Collection<Repository> getAllRepositories() {
        return this.configuredRepositories.getAllConfiguredRepositories();
    }

    public Collection<Repository> getRepositories() {
        ArrayList<Repository> result = new ArrayList<Repository>();
        for (Repository repository : this.configuredRepositories.getAllConfiguredRepositories()) {
            if (!this.authorizationManager.authorize((Resource)repository, this.sessionInfo.getIdentity())) continue;
            result.add(repository);
        }
        return result;
    }

    public Repository createRepository(OrganizationalUnit organizationalUnit, String scheme, String alias, RepositoryEnvironmentConfigurations repositoryEnvironmentConfigurations) throws RepositoryAlreadyExistsException {
        try {
            Repository repository = this.createRepository(scheme, alias, repositoryEnvironmentConfigurations);
            if (organizationalUnit != null && repository != null) {
                this.organizationalUnitService.addRepository(organizationalUnit, repository);
            }
            this.metadataStore.write(alias, (String)repositoryEnvironmentConfigurations.getOrigin());
            return repository;
        }
        catch (Exception e) {
            logger.error("Error during create repository", (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected ConfigGroup findRepositoryConfig(String alias) {
        List groups = this.configurationService.getConfiguration(ConfigType.REPOSITORY);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                if (!groupConfig.getName().equals(alias)) continue;
                return groupConfig;
            }
        }
        return null;
    }

    public void removeRepository(String alias) {
        ConfigGroup thisRepositoryConfig = this.findRepositoryConfig(alias);
        try {
            Repository repo;
            this.configurationService.startBatch();
            if (thisRepositoryConfig != null) {
                this.configurationService.removeConfiguration(thisRepositoryConfig);
            }
            if ((repo = this.configuredRepositories.remove(alias)) != null) {
                this.repositoryRemovedEvent.fire((Object)new RepositoryRemovedEvent(repo));
                this.ioService.delete(Paths.convert((Path)repo.getRoot()).getFileSystem().getPath(null, new String[0]), new DeleteOption[0]);
            }
            Collection organizationalUnits = this.organizationalUnitService.getAllOrganizationalUnits();
            for (OrganizationalUnit ou : organizationalUnits) {
                for (Repository repository : ou.getRepositories()) {
                    if (!repository.getAlias().equals(alias)) continue;
                    this.organizationalUnitService.removeRepository(ou, repository);
                    this.metadataStore.delete(alias);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error during remove repository", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.configurationService.endBatch();
        }
    }

    public Repository createRepository(String scheme, String alias, RepositoryEnvironmentConfigurations repositoryEnvironmentConfigurations) {
        Repository repository;
        if (this.configuredRepositories.containsAlias(alias)) {
            throw new RepositoryAlreadyExistsException(alias);
        }
        Repository repo = null;
        try {
            this.configurationService.startBatch();
            ConfigGroup repositoryConfig = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, alias, "");
            repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("security:groups", new ArrayList()));
            if (!repositoryEnvironmentConfigurations.containsConfiguration("scheme")) {
                repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("scheme", scheme));
            }
            for (RepositoryEnvironmentConfiguration configuration : repositoryEnvironmentConfigurations.getConfigurationList()) {
                repositoryConfig.addConfigItem(this.getRepositoryConfigItem(configuration));
            }
            repository = repo = this.createRepository(repositoryConfig);
        }
        catch (Exception e) {
            try {
                logger.error("Error during create repository", (Throwable)e);
                throw ExceptionUtilities.handleException((Exception)e);
            }
            catch (Throwable throwable) {
                this.configurationService.endBatch();
                if (repo != null) {
                    this.event.fire((Object)new NewRepositoryEvent(repo));
                }
                throw throwable;
            }
        }
        this.configurationService.endBatch();
        if (repo != null) {
            this.event.fire((Object)new NewRepositoryEvent(repo));
        }
        return repository;
    }

    private ConfigItem getRepositoryConfigItem(RepositoryEnvironmentConfiguration configuration) {
        if (configuration.isSecuredConfigurationItem()) {
            return this.configurationFactory.newSecuredConfigItem(configuration.getName(), configuration.getValue().toString());
        }
        return this.configurationFactory.newConfigItem(configuration.getName(), configuration.getValue());
    }

    public void addGroup(Repository repository, String group) {
        ConfigGroup thisRepositoryConfig = this.findRepositoryConfig(repository.getAlias());
        if (thisRepositoryConfig == null) {
            throw new IllegalArgumentException("Repository " + repository.getAlias() + " not found");
        }
        ConfigItem groups = this.backward.compat(thisRepositoryConfig).getConfigItem("security:groups");
        ((List)groups.getValue()).add(group);
        this.configurationService.updateConfiguration(thisRepositoryConfig);
        this.configuredRepositories.update(this.repositoryFactory.newRepository(thisRepositoryConfig));
    }

    public void removeGroup(Repository repository, String group) {
        ConfigGroup thisRepositoryConfig = this.findRepositoryConfig(repository.getAlias());
        if (thisRepositoryConfig == null) {
            throw new IllegalArgumentException("Repository " + repository.getAlias() + " not found");
        }
        ConfigItem groups = this.backward.compat(thisRepositoryConfig).getConfigItem("security:groups");
        ((List)groups.getValue()).remove(group);
        this.configurationService.updateConfiguration(thisRepositoryConfig);
        this.configuredRepositories.update(this.repositoryFactory.newRepository(thisRepositoryConfig));
    }

    public List<VersionRecord> getRepositoryHistoryAll(String alias) {
        return this.getRepositoryHistory(alias, 0, -1);
    }

    public Repository updateRepositoryConfiguration(Repository repository, RepositoryEnvironmentConfigurations repositoryEnvironmentConfigurations) {
        ConfigGroup thisRepositoryConfig = this.findRepositoryConfig(repository.getAlias());
        if (thisRepositoryConfig != null && repositoryEnvironmentConfigurations != null) {
            try {
                this.configurationService.startBatch();
                for (Map.Entry entry : repositoryEnvironmentConfigurations.getConfigurationMap().entrySet()) {
                    ConfigItem configItem = thisRepositoryConfig.getConfigItem((String)entry.getKey());
                    if (configItem == null) {
                        thisRepositoryConfig.addConfigItem(this.configurationFactory.newConfigItem((String)entry.getKey(), entry.getValue()));
                        continue;
                    }
                    configItem.setValue(entry.getValue());
                }
                this.configurationService.updateConfiguration(thisRepositoryConfig);
                Repository updatedRepo = this.repositoryFactory.newRepository(thisRepositoryConfig);
                this.configuredRepositories.update(updatedRepo);
                Repository repository2 = updatedRepo;
                return repository2;
            }
            catch (Exception e) {
                logger.error("Error during remove repository", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                this.configurationService.endBatch();
            }
        }
        throw new IllegalArgumentException("Repository " + repository.getAlias() + " not found");
    }
}

