/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.Transformer;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodGraph;
import net.bytebuddy.dynamic.scaffold.TypeInitializer;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.dynamic.scaffold.TypeWriter;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.LatentMatcher;
import net.bytebuddy.utility.CompoundList;

public interface MethodRegistry {
    public MethodRegistry prepend(LatentMatcher<? super MethodDescription> var1, Handler var2, MethodAttributeAppender.Factory var3, Transformer<MethodDescription> var4);

    public MethodRegistry append(LatentMatcher<? super MethodDescription> var1, Handler var2, MethodAttributeAppender.Factory var3, Transformer<MethodDescription> var4);

    public Prepared prepare(InstrumentedType var1, MethodGraph.Compiler var2, TypeValidation var3, LatentMatcher<? super MethodDescription> var4);

    public static class Default
    implements MethodRegistry {
        private final List<Entry> entries;

        public Default() {
            this.entries = Collections.emptyList();
        }

        private Default(List<Entry> entries) {
            this.entries = entries;
        }

        @Override
        public MethodRegistry prepend(LatentMatcher<? super MethodDescription> matcher, Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory, Transformer<MethodDescription> transformer) {
            return new Default(CompoundList.of(new Entry(matcher, handler, attributeAppenderFactory, transformer), this.entries));
        }

        @Override
        public MethodRegistry append(LatentMatcher<? super MethodDescription> matcher, Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory, Transformer<MethodDescription> transformer) {
            return new Default(CompoundList.of(this.entries, new Entry(matcher, handler, attributeAppenderFactory, transformer)));
        }

        @Override
        public net.bytebuddy.dynamic.scaffold.MethodRegistry$Prepared prepare(InstrumentedType instrumentedType, MethodGraph.Compiler methodGraphCompiler, TypeValidation typeValidation, LatentMatcher<? super MethodDescription> ignoredMethods) {
            LinkedHashMap<MethodDescription, Prepared.Entry> implementations = new LinkedHashMap<MethodDescription, Prepared.Entry>();
            HashSet<Handler> handlers = new HashSet<Handler>();
            MethodList<MethodDescription.InDefinedShape> helperMethods = instrumentedType.getDeclaredMethods();
            for (Entry entry : this.entries) {
                if (!handlers.add(entry.getHandler())) continue;
                instrumentedType = entry.getHandler().prepare(instrumentedType);
                ElementMatcher.Junction handledMethods = ElementMatchers.noneOf(helperMethods);
                helperMethods = instrumentedType.getDeclaredMethods();
                for (MethodDescription helperMethod : (MethodList)helperMethods.filter(handledMethods)) {
                    implementations.put(helperMethod, entry.asSupplementaryEntry(helperMethod));
                }
            }
            MethodGraph.Linked methodGraph = methodGraphCompiler.compile(instrumentedType);
            ElementMatcher.Junction<? super MethodDescription> relevanceMatcher = ElementMatchers.not(ElementMatchers.anyOf(implementations.keySet())).and(ElementMatchers.returns(ElementMatchers.isVisibleTo(instrumentedType))).and(ElementMatchers.hasParameters(ElementMatchers.whereNone(ElementMatchers.hasType(ElementMatchers.not(ElementMatchers.isVisibleTo(instrumentedType)))))).and(ignoredMethods.resolve(instrumentedType));
            for (MethodGraph.Node node : methodGraph.listNodes()) {
                boolean visibilityBridge;
                MethodDescription methodDescription = node.getRepresentative();
                boolean bl = visibilityBridge = instrumentedType.isPublic() && !instrumentedType.isInterface();
                if (relevanceMatcher.matches(methodDescription)) {
                    for (Entry entry : this.entries) {
                        if (!entry.resolve(instrumentedType).matches(methodDescription)) continue;
                        implementations.put(methodDescription, entry.asPreparedEntry(instrumentedType, methodDescription, node.getMethodTypes()));
                        visibilityBridge = false;
                        break;
                    }
                }
                if (!visibilityBridge || !methodDescription.isPublic() || methodDescription.isAbstract() || methodDescription.isFinal() || node.getSort().isMadeVisible() || !methodDescription.getDeclaringType().isPackagePrivate()) continue;
                implementations.put(methodDescription, Prepared.Entry.forVisibilityBridge(methodDescription));
            }
            block4: for (MethodDescription methodDescription : CompoundList.of(instrumentedType.getDeclaredMethods().filter(ElementMatchers.not(ElementMatchers.isVirtual()).and(relevanceMatcher)), new MethodDescription.Latent.TypeInitializer(instrumentedType))) {
                for (Entry entry : this.entries) {
                    if (!entry.resolve(instrumentedType).matches(methodDescription)) continue;
                    implementations.put(methodDescription, entry.asPreparedEntry(instrumentedType, methodDescription));
                    continue block4;
                }
            }
            return new Prepared(implementations, instrumentedType.getLoadedTypeInitializer(), instrumentedType.getTypeInitializer(), typeValidation.isEnabled() ? instrumentedType.validated() : instrumentedType, methodGraph);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((Default)other).entries);
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public String toString() {
            return "MethodRegistry.Default{entries=" + this.entries + '}';
        }

        protected static class Compiled
        implements net.bytebuddy.dynamic.scaffold.MethodRegistry$Compiled {
            private final TypeDescription instrumentedType;
            private final LoadedTypeInitializer loadedTypeInitializer;
            private final TypeInitializer typeInitializer;
            private final LinkedHashMap<MethodDescription, Entry> implementations;
            private final boolean supportsBridges;

            protected Compiled(TypeDescription instrumentedType, LoadedTypeInitializer loadedTypeInitializer, TypeInitializer typeInitializer, LinkedHashMap<MethodDescription, Entry> implementations, boolean supportsBridges) {
                this.instrumentedType = instrumentedType;
                this.loadedTypeInitializer = loadedTypeInitializer;
                this.typeInitializer = typeInitializer;
                this.implementations = implementations;
                this.supportsBridges = supportsBridges;
            }

            @Override
            public TypeDescription getInstrumentedType() {
                return this.instrumentedType;
            }

            @Override
            public LoadedTypeInitializer getLoadedTypeInitializer() {
                return this.loadedTypeInitializer;
            }

            @Override
            public TypeInitializer getTypeInitializer() {
                return this.typeInitializer;
            }

            @Override
            public MethodList<?> getInstrumentedMethods() {
                return (MethodList)new MethodList.Explicit<MethodDescription>((List<MethodDescription>)new ArrayList<MethodDescription>(this.implementations.keySet())).filter(ElementMatchers.not(ElementMatchers.isTypeInitializer()));
            }

            @Override
            public TypeWriter.MethodPool.Record target(MethodDescription methodDescription) {
                Entry entry = this.implementations.get(methodDescription);
                return entry == null ? TypeWriter.MethodPool.Record.ForNonDefinedMethod.INSTANCE : entry.bind(this.instrumentedType, this.supportsBridges);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Compiled compiled = (Compiled)other;
                return this.instrumentedType.equals(compiled.instrumentedType) && this.loadedTypeInitializer.equals(compiled.loadedTypeInitializer) && this.typeInitializer.equals(compiled.typeInitializer) && this.implementations.equals(compiled.implementations) && this.supportsBridges == compiled.supportsBridges;
            }

            public int hashCode() {
                int result = this.instrumentedType.hashCode();
                result = 31 * result + this.loadedTypeInitializer.hashCode();
                result = 31 * result + this.typeInitializer.hashCode();
                result = 31 * result + this.implementations.hashCode();
                result = 31 * result + (this.supportsBridges ? 1 : 0);
                return result;
            }

            public String toString() {
                return "MethodRegistry.Default.Compiled{instrumentedType=" + this.instrumentedType + ", loadedTypeInitializer=" + this.loadedTypeInitializer + ", typeInitializer=" + this.typeInitializer + ", implementations=" + this.implementations + ", supportsBridges=" + this.supportsBridges + '}';
            }

            protected static class Entry {
                private final Handler.Compiled handler;
                private final MethodAttributeAppender attributeAppender;
                private final MethodDescription methodDescription;
                private final Set<MethodDescription.TypeToken> bridgeTypes;
                private final boolean bridgeMethod;

                protected Entry(Handler.Compiled handler, MethodAttributeAppender attributeAppender, MethodDescription methodDescription, Set<MethodDescription.TypeToken> bridgeTypes, boolean bridgeMethod) {
                    this.handler = handler;
                    this.attributeAppender = attributeAppender;
                    this.methodDescription = methodDescription;
                    this.bridgeTypes = bridgeTypes;
                    this.bridgeMethod = bridgeMethod;
                }

                protected TypeWriter.MethodPool.Record bind(TypeDescription instrumentedType, boolean supportsBridges) {
                    if (this.bridgeMethod && !supportsBridges) {
                        return TypeWriter.MethodPool.Record.ForNonDefinedMethod.INSTANCE;
                    }
                    TypeWriter.MethodPool.Record record = this.handler.assemble(this.methodDescription, this.attributeAppender);
                    return supportsBridges ? TypeWriter.MethodPool.Record.AccessBridgeWrapper.of(record, instrumentedType, this.methodDescription, this.bridgeTypes, this.attributeAppender) : record;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Entry entry = (Entry)other;
                    return this.handler.equals(entry.handler) && this.bridgeMethod == entry.bridgeMethod && this.attributeAppender.equals(entry.attributeAppender) && this.methodDescription.equals(entry.methodDescription) && this.bridgeTypes.equals(entry.bridgeTypes);
                }

                public int hashCode() {
                    int result = this.handler.hashCode();
                    result = 31 * result + (this.bridgeMethod ? 1 : 0);
                    result = 31 * result + this.attributeAppender.hashCode();
                    result = 31 * result + this.methodDescription.hashCode();
                    result = 31 * result + this.bridgeTypes.hashCode();
                    return result;
                }

                public String toString() {
                    return "MethodRegistry.Default.Compiled.Entry{handler=" + this.handler + ", attributeAppender=" + this.attributeAppender + ", methodDescription=" + this.methodDescription + ", bridgeTypes=" + this.bridgeTypes + ", bridgeMethod=" + this.bridgeMethod + '}';
                }
            }
        }

        protected static class Prepared
        implements net.bytebuddy.dynamic.scaffold.MethodRegistry$Prepared {
            private final LinkedHashMap<MethodDescription, Entry> implementations;
            private final LoadedTypeInitializer loadedTypeInitializer;
            private final TypeInitializer typeInitializer;
            private final TypeDescription instrumentedType;
            private final MethodGraph.Linked methodGraph;

            protected Prepared(LinkedHashMap<MethodDescription, Entry> implementations, LoadedTypeInitializer loadedTypeInitializer, TypeInitializer typeInitializer, TypeDescription instrumentedType, MethodGraph.Linked methodGraph) {
                this.implementations = implementations;
                this.loadedTypeInitializer = loadedTypeInitializer;
                this.typeInitializer = typeInitializer;
                this.instrumentedType = instrumentedType;
                this.methodGraph = methodGraph;
            }

            @Override
            public TypeDescription getInstrumentedType() {
                return this.instrumentedType;
            }

            @Override
            public LoadedTypeInitializer getLoadedTypeInitializer() {
                return this.loadedTypeInitializer;
            }

            @Override
            public TypeInitializer getTypeInitializer() {
                return this.typeInitializer;
            }

            @Override
            public MethodList<?> getInstrumentedMethods() {
                return (MethodList)new MethodList.Explicit<MethodDescription>((List<MethodDescription>)new ArrayList<MethodDescription>(this.implementations.keySet())).filter(ElementMatchers.not(ElementMatchers.isTypeInitializer()));
            }

            @Override
            public net.bytebuddy.dynamic.scaffold.MethodRegistry$Compiled compile(Implementation.Target.Factory implementationTargetFactory, ClassFileVersion classFileVersion) {
                HashMap<Handler, Handler.Compiled> compilationCache = new HashMap<Handler, Handler.Compiled>();
                HashMap<MethodAttributeAppender.Factory, MethodAttributeAppender> attributeAppenderCache = new HashMap<MethodAttributeAppender.Factory, MethodAttributeAppender>();
                LinkedHashMap<MethodDescription, Compiled.Entry> entries = new LinkedHashMap<MethodDescription, Compiled.Entry>();
                Implementation.Target implementationTarget = implementationTargetFactory.make(this.instrumentedType, this.methodGraph, classFileVersion);
                for (Map.Entry<MethodDescription, Entry> entry : this.implementations.entrySet()) {
                    MethodAttributeAppender cachedAttributeAppender;
                    Handler.Compiled cachedHandler = (Handler.Compiled)compilationCache.get(entry.getValue().getHandler());
                    if (cachedHandler == null) {
                        cachedHandler = entry.getValue().getHandler().compile(implementationTarget);
                        compilationCache.put(entry.getValue().getHandler(), cachedHandler);
                    }
                    if ((cachedAttributeAppender = (MethodAttributeAppender)attributeAppenderCache.get(entry.getValue().getAppenderFactory())) == null) {
                        cachedAttributeAppender = entry.getValue().getAppenderFactory().make(this.instrumentedType);
                        attributeAppenderCache.put(entry.getValue().getAppenderFactory(), cachedAttributeAppender);
                    }
                    entries.put(entry.getKey(), new Compiled.Entry(cachedHandler, cachedAttributeAppender, entry.getValue().getMethodDescription(), entry.getValue().resolveBridgeTypes(), entry.getValue().isBridgeMethod()));
                }
                return new Compiled(this.instrumentedType, this.loadedTypeInitializer, this.typeInitializer, entries, classFileVersion.isAtLeast(ClassFileVersion.JAVA_V5));
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Prepared prepared = (Prepared)other;
                return this.implementations.equals(prepared.implementations) && this.loadedTypeInitializer.equals(prepared.loadedTypeInitializer) && this.typeInitializer.equals(prepared.typeInitializer) && this.instrumentedType.equals(prepared.instrumentedType) && this.methodGraph.equals(prepared.methodGraph);
            }

            public int hashCode() {
                int result = this.implementations.hashCode();
                result = 31 * result + this.loadedTypeInitializer.hashCode();
                result = 31 * result + this.typeInitializer.hashCode();
                result = 31 * result + this.instrumentedType.hashCode();
                result = 31 * result + this.methodGraph.hashCode();
                return result;
            }

            public String toString() {
                return "MethodRegistry.Default.Prepared{implementations=" + this.implementations + ", loadedTypeInitializer=" + this.loadedTypeInitializer + ", typeInitializer=" + this.typeInitializer + ", instrumentedType=" + this.instrumentedType + ", methodGraph=" + this.methodGraph + '}';
            }

            protected static class Entry {
                private final Handler handler;
                private final MethodAttributeAppender.Factory attributeAppenderFactory;
                private final MethodDescription methodDescription;
                private final Set<MethodDescription.TypeToken> typeTokens;
                private final boolean bridgeMethod;

                protected Entry(Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory, MethodDescription methodDescription, Set<MethodDescription.TypeToken> typeTokens, boolean bridgeMethod) {
                    this.handler = handler;
                    this.attributeAppenderFactory = attributeAppenderFactory;
                    this.methodDescription = methodDescription;
                    this.typeTokens = typeTokens;
                    this.bridgeMethod = bridgeMethod;
                }

                protected static Entry forVisibilityBridge(MethodDescription bridgeTarget) {
                    return new Entry(Handler.ForVisibilityBridge.INSTANCE, MethodAttributeAppender.Explicit.of(bridgeTarget), bridgeTarget, Collections.<MethodDescription.TypeToken>emptySet(), true);
                }

                protected Handler getHandler() {
                    return this.handler;
                }

                protected MethodAttributeAppender.Factory getAppenderFactory() {
                    return this.attributeAppenderFactory;
                }

                protected MethodDescription getMethodDescription() {
                    return this.methodDescription;
                }

                protected Set<MethodDescription.TypeToken> resolveBridgeTypes() {
                    HashSet<MethodDescription.TypeToken> typeTokens = new HashSet<MethodDescription.TypeToken>(this.typeTokens);
                    typeTokens.remove(this.methodDescription.asTypeToken());
                    return typeTokens;
                }

                protected boolean isBridgeMethod() {
                    return this.bridgeMethod;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Entry entry = (Entry)other;
                    return this.handler.equals(entry.handler) && this.bridgeMethod == entry.bridgeMethod && this.attributeAppenderFactory.equals(entry.attributeAppenderFactory) && this.methodDescription.equals(entry.methodDescription) && this.typeTokens.equals(entry.typeTokens);
                }

                public int hashCode() {
                    int result = this.handler.hashCode();
                    result = 31 * result + (this.bridgeMethod ? 1 : 0);
                    result = 31 * result + this.attributeAppenderFactory.hashCode();
                    result = 31 * result + this.methodDescription.hashCode();
                    result = 31 * result + this.typeTokens.hashCode();
                    return result;
                }

                public String toString() {
                    return "MethodRegistry.Default.Prepared.Entry{handler=" + this.handler + ", attributeAppenderFactory=" + this.attributeAppenderFactory + ", methodDescription=" + this.methodDescription + ", typeTokens=" + this.typeTokens + ", bridgeMethod=" + this.bridgeMethod + '}';
                }
            }
        }

        protected static class Entry
        implements LatentMatcher<MethodDescription> {
            private final LatentMatcher<? super MethodDescription> matcher;
            private final Handler handler;
            private final MethodAttributeAppender.Factory attributeAppenderFactory;
            private final Transformer<MethodDescription> transformer;

            protected Entry(LatentMatcher<? super MethodDescription> matcher, Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory, Transformer<MethodDescription> transformer) {
                this.matcher = matcher;
                this.handler = handler;
                this.attributeAppenderFactory = attributeAppenderFactory;
                this.transformer = transformer;
            }

            protected Prepared.Entry asPreparedEntry(TypeDescription instrumentedType, MethodDescription methodDescription) {
                return this.asPreparedEntry(instrumentedType, methodDescription, Collections.<MethodDescription.TypeToken>emptySet());
            }

            protected Prepared.Entry asPreparedEntry(TypeDescription instrumentedType, MethodDescription methodDescription, Set<MethodDescription.TypeToken> methodTypes) {
                return new Prepared.Entry(this.handler, this.attributeAppenderFactory, this.transformer.transform(instrumentedType, methodDescription), methodTypes, false);
            }

            protected Prepared.Entry asSupplementaryEntry(MethodDescription methodDescription) {
                return new Prepared.Entry(this.handler, MethodAttributeAppender.Explicit.of(methodDescription), methodDescription, Collections.<MethodDescription.TypeToken>emptySet(), false);
            }

            protected Handler getHandler() {
                return this.handler;
            }

            @Override
            public ElementMatcher<? super MethodDescription> resolve(TypeDescription typeDescription) {
                return this.matcher.resolve(typeDescription);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Entry entry = (Entry)other;
                return this.matcher.equals(entry.matcher) && this.handler.equals(entry.handler) && this.attributeAppenderFactory.equals(entry.attributeAppenderFactory) && this.transformer.equals(entry.transformer);
            }

            public int hashCode() {
                int result = this.matcher.hashCode();
                result = 31 * result + this.handler.hashCode();
                result = 31 * result + this.attributeAppenderFactory.hashCode();
                result = 31 * result + this.transformer.hashCode();
                return result;
            }

            public String toString() {
                return "MethodRegistry.Default.Entry{matcher=" + this.matcher + ", handler=" + this.handler + ", attributeAppenderFactory=" + this.attributeAppenderFactory + ", transformer=" + this.transformer + '}';
            }
        }
    }

    public static interface Compiled
    extends TypeWriter.MethodPool {
        public TypeDescription getInstrumentedType();

        public MethodList getInstrumentedMethods();

        public LoadedTypeInitializer getLoadedTypeInitializer();

        public TypeInitializer getTypeInitializer();
    }

    public static interface Prepared {
        public TypeDescription getInstrumentedType();

        public MethodList<?> getInstrumentedMethods();

        public LoadedTypeInitializer getLoadedTypeInitializer();

        public TypeInitializer getTypeInitializer();

        public Compiled compile(Implementation.Target.Factory var1, ClassFileVersion var2);
    }

    public static interface Handler
    extends InstrumentedType.Prepareable {
        public Compiled compile(Implementation.Target var1);

        public static class ForAnnotationValue
        implements Handler,
        Compiled {
            private final Object annotationValue;

            protected ForAnnotationValue(Object annotationValue) {
                this.annotationValue = annotationValue;
            }

            public static Handler of(Object annotationValue) {
                TypeDescription.ForLoadedType typeDescription = new TypeDescription.ForLoadedType(annotationValue.getClass());
                if (!typeDescription.isAnnotationValue() && !typeDescription.isPrimitiveWrapper()) {
                    throw new IllegalArgumentException("Does not describe an annotation value: " + annotationValue);
                }
                return new ForAnnotationValue(annotationValue);
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public TypeWriter.MethodPool.Record assemble(MethodDescription methodDescription, MethodAttributeAppender attributeAppender) {
                return new TypeWriter.MethodPool.Record.ForDefinedMethod.WithAnnotationDefaultValue(methodDescription, this.annotationValue, attributeAppender);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.annotationValue.equals(((ForAnnotationValue)other).annotationValue);
            }

            public int hashCode() {
                return this.annotationValue.hashCode();
            }

            public String toString() {
                return "MethodRegistry.Handler.ForAnnotationValue{annotationValue=" + this.annotationValue + '}';
            }
        }

        public static class ForImplementation
        implements Handler {
            private final Implementation implementation;

            public ForImplementation(Implementation implementation) {
                this.implementation = implementation;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return this.implementation.prepare(instrumentedType);
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return new Compiled(this.implementation.appender(implementationTarget));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.implementation.equals(((ForImplementation)other).implementation);
            }

            public int hashCode() {
                return this.implementation.hashCode();
            }

            public String toString() {
                return "MethodRegistry.Handler.ForImplementation{implementation=" + this.implementation + '}';
            }

            protected static class Compiled
            implements net.bytebuddy.dynamic.scaffold.MethodRegistry$Handler$Compiled {
                private final ByteCodeAppender byteCodeAppender;

                protected Compiled(ByteCodeAppender byteCodeAppender) {
                    this.byteCodeAppender = byteCodeAppender;
                }

                @Override
                public TypeWriter.MethodPool.Record assemble(MethodDescription methodDescription, MethodAttributeAppender attributeAppender) {
                    return new TypeWriter.MethodPool.Record.ForDefinedMethod.WithBody(methodDescription, this.byteCodeAppender, attributeAppender);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.byteCodeAppender.equals(((Compiled)other).byteCodeAppender);
                }

                public int hashCode() {
                    return this.byteCodeAppender.hashCode();
                }

                public String toString() {
                    return "MethodRegistry.Handler.ForImplementation.Compiled{byteCodeAppender=" + this.byteCodeAppender + '}';
                }
            }
        }

        public static interface Compiled {
            public TypeWriter.MethodPool.Record assemble(MethodDescription var1, MethodAttributeAppender var2);
        }

        public static enum ForVisibilityBridge implements Handler
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                throw new IllegalStateException("A visibility bridge handler must not apply any preparations");
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return new Compiled(implementationTarget.getInstrumentedType());
            }

            public String toString() {
                return "MethodRegistry.Handler.ForVisibilityBridge." + this.name();
            }

            protected static class Compiled
            implements net.bytebuddy.dynamic.scaffold.MethodRegistry$Handler$Compiled {
                private final TypeDescription instrumentedType;

                protected Compiled(TypeDescription instrumentedType) {
                    this.instrumentedType = instrumentedType;
                }

                @Override
                public TypeWriter.MethodPool.Record assemble(MethodDescription methodDescription, MethodAttributeAppender attributeAppender) {
                    return TypeWriter.MethodPool.Record.ForDefinedMethod.OfVisibilityBridge.of(this.instrumentedType, methodDescription, attributeAppender);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Compiled)other).instrumentedType);
                }

                public int hashCode() {
                    return this.instrumentedType.hashCode();
                }

                public String toString() {
                    return "MethodRegistry.Handler.ForVisibilityBridge.Compiled{instrumentedType=" + this.instrumentedType + '}';
                }
            }
        }

        public static enum ForAbstractMethod implements Handler,
        Compiled
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public Compiled compile(Implementation.Target implementationTarget) {
                return this;
            }

            @Override
            public TypeWriter.MethodPool.Record assemble(MethodDescription methodDescription, MethodAttributeAppender attributeAppender) {
                return new TypeWriter.MethodPool.Record.ForDefinedMethod.WithoutBody(methodDescription, attributeAppender);
            }

            public String toString() {
                return "MethodRegistry.Handler.ForAbstractMethod." + this.name();
            }
        }
    }
}

