/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.datamodeller.core.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.kie.workbench.common.services.datamodeller.core.PropertyType;
import org.kie.workbench.common.services.datamodeller.core.PropertyTypeFactory;
import org.kie.workbench.common.services.datamodeller.core.impl.PropertyTypeImpl;

public class PropertyTypeFactoryImpl
implements PropertyTypeFactory {
    private static List<PropertyType> baseTypes = new ArrayList<PropertyType>();
    private static HashMap<String, PropertyType> baseTypesByClass = new HashMap();

    public PropertyTypeFactoryImpl() {
        baseTypes.add(new PropertyTypeImpl("Short", Short.class.getName()));
        baseTypes.add(new PropertyTypeImpl("Integer", Integer.class.getName()));
        baseTypes.add(new PropertyTypeImpl("Long", Long.class.getName()));
        baseTypes.add(new PropertyTypeImpl("Byte", Byte.class.getName()));
        baseTypes.add(new PropertyTypeImpl("Float", Float.class.getName()));
        baseTypes.add(new PropertyTypeImpl("Double", Double.class.getName()));
        baseTypes.add(new PropertyTypeImpl("Date", Date.class.getName()));
        baseTypes.add(new PropertyTypeImpl("LocalDate", "java.time.LocalDate"));
        baseTypes.add(new PropertyTypeImpl("LocalDateTime", "java.time.LocalDateTime"));
        baseTypes.add(new PropertyTypeImpl("LocalTime", "java.time.LocalTime"));
        baseTypes.add(new PropertyTypeImpl("OffsetDateTime", "java.time.OffsetDateTime"));
        baseTypes.add(new PropertyTypeImpl("Boolean", Boolean.class.getName()));
        baseTypes.add(new PropertyTypeImpl("String", String.class.getName()));
        baseTypes.add(new PropertyTypeImpl("Character", Character.class.getName()));
        baseTypes.add(new PropertyTypeImpl("BigDecimal", BigDecimal.class.getName()));
        baseTypes.add(new PropertyTypeImpl("BigInteger", BigInteger.class.getName()));
        baseTypes.add(new PropertyTypeImpl("byte", "byte"));
        baseTypes.add(new PropertyTypeImpl("short", "short"));
        baseTypes.add(new PropertyTypeImpl("int", "int"));
        baseTypes.add(new PropertyTypeImpl("long", "long"));
        baseTypes.add(new PropertyTypeImpl("float", "float"));
        baseTypes.add(new PropertyTypeImpl("double", "double"));
        baseTypes.add(new PropertyTypeImpl("boolean", "boolean"));
        baseTypes.add(new PropertyTypeImpl("char", "char"));
        for (PropertyType type : baseTypes) {
            baseTypesByClass.put(type.getClassName(), type);
        }
    }

    public static PropertyTypeFactory getInstance() {
        return HoldInstance.INSTANCE;
    }

    @Override
    public List<PropertyType> getBasePropertyTypes() {
        return baseTypes;
    }

    @Override
    public boolean isBasePropertyType(String className) {
        return baseTypesByClass.containsKey(className);
    }

    @Override
    public boolean isPrimitivePropertyType(String className) {
        PropertyType type = baseTypesByClass.get(className);
        return type != null && type.isPrimitive();
    }

    private static class HoldInstance {
        private static final PropertyTypeFactoryImpl INSTANCE = new PropertyTypeFactoryImpl();

        private HoldInstance() {
        }
    }
}

