/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import java.util.Date;
import java.util.List;
import org.drools.guvnor.client.common.AssetEditorFactory;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.resources.ComparableImageResource;
import org.drools.guvnor.client.rpc.MetaDataQuery;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.rpc.QueryMetadataPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRequest;
import org.drools.guvnor.client.rpc.QueryPageRow;
import org.drools.guvnor.client.widgets.tables.AbstractAssetPagedTable;
import org.drools.guvnor.client.widgets.tables.ColumnPicker;
import org.drools.guvnor.client.widgets.tables.ComparableImageResourceCell;
import org.drools.guvnor.client.widgets.tables.SortableHeader;
import org.drools.guvnor.client.widgets.tables.SortableHeaderGroup;
import org.drools.guvnor.client.widgets.tables.TitledTextCell;
import org.drools.guvnor.client.widgets.tables.TitledTextColumn;

public class QueryPagedTable
extends AbstractAssetPagedTable<QueryPageRow> {
    private static final int PAGE_SIZE = 10;
    private final ClientFactory clientFactory;

    public QueryPagedTable(final List<MetaDataQuery> metadata, final Date createdAfter, final Date createdBefore, final Date lastModifiedAfter, final Date lastModifiedBefore, final Boolean searchArchived, ClientFactory clientFactory) {
        super(10, clientFactory);
        this.clientFactory = clientFactory;
        this.setDataProvider(new AsyncDataProvider<QueryPageRow>(){

            protected void onRangeChanged(HasData<QueryPageRow> display) {
                QueryMetadataPageRequest request = new QueryMetadataPageRequest();
                request.setMetadata(metadata);
                request.setCreatedAfter(createdAfter);
                request.setCreatedBefore(createdBefore);
                request.setLastModifiedAfter(lastModifiedAfter);
                request.setLastModifiedBefore(lastModifiedBefore);
                request.setSearchArchived(searchArchived);
                request.setStartRowIndex(QueryPagedTable.this.pager.getPageStart());
                request.setPageSize(QueryPagedTable.this.pageSize);
                QueryPagedTable.this.repositoryService.queryMetaData(request, (AsyncCallback<PageResponse<QueryPageRow>>)new GenericCallback<PageResponse<QueryPageRow>>(){

                    public void onSuccess(PageResponse<QueryPageRow> response) {
                        this.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
                        this.updateRowData(response.getStartRowIndex(), response.getPageRowList());
                    }
                });
            }
        });
    }

    public QueryPagedTable(final String searchText, final Boolean searchArchived, ClientFactory clientFactory) {
        super(10, clientFactory);
        this.clientFactory = clientFactory;
        this.setDataProvider(new AsyncDataProvider<QueryPageRow>(){

            protected void onRangeChanged(HasData<QueryPageRow> display) {
                QueryPageRequest request = new QueryPageRequest();
                request.setSearchText(searchText);
                request.setSearchArchived(searchArchived);
                request.setStartRowIndex(QueryPagedTable.this.pager.getPageStart());
                request.setPageSize(QueryPagedTable.this.pageSize);
                QueryPagedTable.this.repositoryService.queryFullText(request, (AsyncCallback<PageResponse<QueryPageRow>>)new GenericCallback<PageResponse<QueryPageRow>>(){

                    public void onSuccess(PageResponse<QueryPageRow> response) {
                        this.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
                        this.updateRowData(response.getStartRowIndex(), response.getPageRowList());
                    }
                });
            }
        });
    }

    public QueryPagedTable(final String searchText, final Boolean searchArchived, final Boolean isCaseSensitive, ClientFactory clientFactory) {
        super(10, clientFactory);
        this.clientFactory = clientFactory;
        this.setDataProvider(new AsyncDataProvider<QueryPageRow>(){

            protected void onRangeChanged(HasData<QueryPageRow> display) {
                QueryPageRequest request = new QueryPageRequest();
                request.setSearchText(searchText);
                request.setSearchArchived(searchArchived);
                request.setIsCaseSensitive(isCaseSensitive);
                request.setStartRowIndex(QueryPagedTable.this.pager.getPageStart());
                request.setPageSize(QueryPagedTable.this.pageSize);
                QueryPagedTable.this.assetService.quickFindAsset(request, (AsyncCallback<PageResponse<QueryPageRow>>)new GenericCallback<PageResponse<QueryPageRow>>(){

                    public void onSuccess(PageResponse<QueryPageRow> response) {
                        this.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
                        this.updateRowData(response.getStartRowIndex(), response.getPageRowList());
                    }
                });
            }
        });
    }

    @Override
    protected void addAncillaryColumns(ColumnPicker<QueryPageRow> columnPicker, SortableHeaderGroup<QueryPageRow> sortableHeaderGroup) {
        Column<QueryPageRow, ComparableImageResource> formatColumn = new Column<QueryPageRow, ComparableImageResource>((Cell)new ComparableImageResourceCell()){

            public ComparableImageResource getValue(QueryPageRow row) {
                AssetEditorFactory factory = QueryPagedTable.this.clientFactory.getAssetEditorFactory();
                return new ComparableImageResource(row.getFormat(), factory.getAssetEditorIcon(row.getFormat()));
            }
        };
        columnPicker.addColumn(formatColumn, new SortableHeader<QueryPageRow, ComparableImageResource>(sortableHeaderGroup, constants.Format(), formatColumn), true);
        TitledTextColumn<QueryPageRow> titleColumn = new TitledTextColumn<QueryPageRow>(){

            public TitledTextCell.TitledText getValue(QueryPageRow row) {
                return new TitledTextCell.TitledText(row.getName(), row.getAbbreviatedDescription());
            }
        };
        columnPicker.addColumn(titleColumn, new SortableHeader<QueryPageRow, TitledTextCell.TitledText>(sortableHeaderGroup, constants.Name(), titleColumn), true);
        TextColumn<QueryPageRow> packageNameColumn = new TextColumn<QueryPageRow>(){

            public String getValue(QueryPageRow row) {
                return row.getPackageName();
            }
        };
        columnPicker.addColumn((Column<QueryPageRow, ?>)packageNameColumn, new SortableHeader(sortableHeaderGroup, constants.PackageName(), packageNameColumn), false);
        Column<QueryPageRow, Date> createdDateColumn = new Column<QueryPageRow, Date>((Cell)new DateCell(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM))){

            public Date getValue(QueryPageRow row) {
                return row.getCreatedDate();
            }
        };
        columnPicker.addColumn(createdDateColumn, new SortableHeader<QueryPageRow, Date>(sortableHeaderGroup, constants.CreatedDate(), createdDateColumn), false);
        Column<QueryPageRow, Date> lastModifiedColumn = new Column<QueryPageRow, Date>((Cell)new DateCell(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM))){

            public Date getValue(QueryPageRow row) {
                return row.getLastModified();
            }
        };
        columnPicker.addColumn(lastModifiedColumn, new SortableHeader<QueryPageRow, Date>(sortableHeaderGroup, constants.LastModified(), lastModifiedColumn), true);
    }
}

