/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.server.util.DroolsHeader;
import org.drools.repository.ModuleItem;

public class ModuleFactory {
    public static Module createModuleWithDependencies(ModuleItem item) {
        Module data = ModuleFactory.create(item);
        data.setDependencies(item.getDependencies());
        return data;
    }

    public static Module createModuleWithOutDependencies(ModuleItem item) {
        return ModuleFactory.create(item);
    }

    private static Module create(ModuleItem item) {
        Module data = new Module();
        data.setUuid(item.getUUID());
        data.setHeader(DroolsHeader.getDroolsHeader(item));
        data.setExternalURI(item.getExternalURI());
        data.setCatRules(item.getCategoryRules());
        data.setDescription(item.getDescription());
        data.setArchived(item.isArchived());
        data.setName(item.getName());
        data.setLastModified(item.getLastModified().getTime());
        data.setDateCreated(item.getCreatedDate().getTime());
        data.setCheckinComment(item.getCheckinComment());
        data.setLastContributor(item.getLastContributor());
        data.setState(item.getStateDescription());
        data.setSnapshot(item.isSnapshot());
        data.setVersionNumber(item.getVersionNumber());
        data.setFormat(item.getFormat());
        return data;
    }
}

