/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation.asset;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.services.backend.builder.core.Builder;
import org.kie.workbench.common.services.backend.builder.core.LRUBuilderCache;
import org.kie.workbench.common.services.backend.builder.service.BuildInfo;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoImpl;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.backend.validation.asset.NoProjectException;
import org.kie.workbench.common.services.backend.validation.asset.ValidatorResultBuilder;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class ValidatorBuildService {
    private static final String ERROR_CLASS_NOT_FOUND = "Definition of class \"{0}\" was not found. Consequentially validation cannot be performed.\nPlease check the necessary external dependencies for this project are configured correctly.";
    private IOService ioService;
    private LRUBuilderCache builderCache;
    private KieProjectService projectService;
    private BuildInfoService buildInfoService;

    public ValidatorBuildService() {
    }

    @Inject
    public ValidatorBuildService(@Named(value="ioStrategy") IOService ioService, LRUBuilderCache builderCache, KieProjectService projectService, BuildInfoService buildInfoService) {
        this.ioService = ioService;
        this.builderCache = builderCache;
        this.projectService = projectService;
        this.buildInfoService = buildInfoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path resourcePath, String content) {
        ByteArrayInputStream inputStream = null;
        try {
            List<ValidationMessage> results;
            inputStream = new ByteArrayInputStream(content.getBytes(Charsets.UTF_8));
            List<ValidationMessage> list = results = this.doValidation(resourcePath, inputStream);
            return list;
        }
        catch (NoProjectException e) {
            ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
            return arrayList;
        }
        catch (NoClassDefFoundError e) {
            ArrayList<ValidationMessage> arrayList = this.error(MessageFormat.format(ERROR_CLASS_NOT_FOUND, e.getLocalizedMessage()));
            return arrayList;
        }
        catch (Throwable e2) {
            ArrayList<ValidationMessage> arrayList;
            block20: {
                arrayList = this.error(e2.getLocalizedMessage());
                if (inputStream == null) break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return arrayList;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<ValidationMessage> validate(org.uberfire.backend.vfs.Path resourcePath) {
        InputStream inputStream = null;
        try {
            List<ValidationMessage> results;
            inputStream = this.ioService.newInputStream(Paths.convert((org.uberfire.backend.vfs.Path)resourcePath), new OpenOption[0]);
            List<ValidationMessage> list = results = this.doValidation(resourcePath, inputStream);
            return list;
        }
        catch (NoProjectException e) {
            ArrayList<ValidationMessage> arrayList = new ArrayList<ValidationMessage>();
            return arrayList;
        }
        catch (NoClassDefFoundError e) {
            ArrayList<ValidationMessage> arrayList = this.error(MessageFormat.format(ERROR_CLASS_NOT_FOUND, e.getLocalizedMessage()));
            return arrayList;
        }
        catch (Throwable e2) {
            ArrayList<ValidationMessage> arrayList;
            block20: {
                arrayList = this.error(e2.getLocalizedMessage());
                if (inputStream == null) break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return arrayList;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private List<ValidationMessage> doValidation(org.uberfire.backend.vfs.Path resourcePath, InputStream inputStream) throws NoProjectException {
        ValidatorResultBuilder resultBuilder = new ValidatorResultBuilder();
        Project project = this.project(resourcePath);
        Path nioResourcePath = Paths.convert((org.uberfire.backend.vfs.Path)resourcePath);
        if (this.isIncrementalBuildPossible(resourcePath)) {
            BuildInfo buildInfo = this.buildInfoService.getBuildInfo(project);
            Builder clone = ((BuildInfoImpl)buildInfo).getBuilder().clone();
            clone.deleteResource(nioResourcePath);
            IncrementalBuildResults incrementalBuildResults = clone.updateResource(nioResourcePath, inputStream);
            resultBuilder.add(incrementalBuildResults.getAddedMessages());
        } else {
            Builder builder = this.builderCache.assertBuilder(this.project(resourcePath));
            Builder clone = builder.clone();
            resultBuilder.add(clone.build(nioResourcePath, inputStream).getMessages());
        }
        return resultBuilder.results();
    }

    private boolean isIncrementalBuildPossible(org.uberfire.backend.vfs.Path resourcePath) throws NoProjectException {
        boolean isResource = this.getDestinationPath(resourcePath).startsWith("src/main/resources/");
        return isResource;
    }

    private String getDestinationPath(org.uberfire.backend.vfs.Path path) throws NoProjectException {
        int rootPathLength = this.project(path).getRootPath().toURI().length() + 1;
        return path.toURI().substring(rootPathLength);
    }

    private Project project(org.uberfire.backend.vfs.Path resourcePath) throws NoProjectException {
        Project project = this.projectService.resolveProject(resourcePath);
        if (project == null) {
            throw new NoProjectException();
        }
        return project;
    }

    private ArrayList<ValidationMessage> error(final String errorMessage) {
        return new ArrayList<ValidationMessage>(){
            {
                this.add(new ValidationMessage(Level.ERROR, errorMessage));
            }
        };
    }
}

