/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;
import opennlp.tools.coref.resolver.ResolverUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProperNounResolver
extends MaxentResolver {
    private static Map<String, Set<String>> acroMap;
    private static boolean acroMapLoaded;

    public ProperNounResolver(String projectName, ResolverMode m) throws IOException {
        super(projectName, "pnmodel", m, 500);
        if (!acroMapLoaded) {
            this.initAcronyms(projectName + "/acronyms");
            acroMapLoaded = true;
        }
        this.showExclusions = false;
    }

    public ProperNounResolver(String projectName, ResolverMode m, NonReferentialResolver nonRefResolver) throws IOException {
        super(projectName, "pnmodel", m, 500, nonRefResolver);
        if (!acroMapLoaded) {
            this.initAcronyms(projectName + "/acronyms");
            acroMapLoaded = true;
        }
        this.showExclusions = false;
    }

    @Override
    public boolean canResolve(MentionContext mention) {
        return mention.getHeadTokenTag().startsWith("NNP") || mention.getHeadTokenTag().startsWith("CD");
    }

    private void initAcronyms(String name) {
        acroMap = new HashMap<String, Set<String>>(15000);
        try {
            String line;
            BufferedReader str = new BufferedReader(new FileReader(name));
            while (null != (line = str.readLine())) {
                StringTokenizer st = new StringTokenizer(line, "\t");
                String acro = st.nextToken();
                String full = st.nextToken();
                Set<String> exSet = acroMap.get(acro);
                if (exSet == null) {
                    exSet = new HashSet<String>();
                    acroMap.put(acro, exSet);
                }
                exSet.add(full);
                exSet = acroMap.get(full);
                if (exSet == null) {
                    exSet = new HashSet<String>();
                    acroMap.put(full, exSet);
                }
                exSet.add(acro);
            }
        }
        catch (IOException e) {
            System.err.println("ProperNounResolver.initAcronyms: Acronym Database not found: " + e);
        }
    }

    private boolean isAcronym(String ecStrip, String xecStrip) {
        Set<String> exSet = acroMap.get(ecStrip);
        return exSet != null && exSet.contains(xecStrip);
    }

    protected List<String> getAcronymFeatures(MentionContext mention, DiscourseEntity entity) {
        MentionContext xec = ResolverUtils.getProperNounExtent(entity);
        String ecStrip = ResolverUtils.stripNp(mention);
        String xecStrip = ResolverUtils.stripNp(xec);
        if (ecStrip != null && xecStrip != null && this.isAcronym(ecStrip, xecStrip)) {
            ArrayList<String> features = new ArrayList<String>(1);
            features.add("knownAcronym");
            return features;
        }
        return Collections.emptyList();
    }

    @Override
    protected List<String> getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList<String> features = new ArrayList<String>();
        features.addAll(super.getFeatures(mention, entity));
        if (entity != null) {
            features.addAll(ResolverUtils.getStringMatchFeatures(mention, entity));
            features.addAll(this.getAcronymFeatures(mention, entity));
        }
        return features;
    }

    @Override
    public boolean excluded(MentionContext mention, DiscourseEntity entity) {
        if (super.excluded(mention, entity)) {
            return true;
        }
        Iterator<MentionContext> ei = entity.getMentions();
        while (ei.hasNext()) {
            MentionContext xec = ei.next();
            if (!xec.getHeadTokenTag().startsWith("NNP")) continue;
            return false;
        }
        return true;
    }

    static {
        acroMapLoaded = false;
    }
}

