/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.ReflectionDiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.jandex.Jandex;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.resources.spi.ResourceLoader;

public final class DiscoveryStrategyFactory {
    private DiscoveryStrategyFactory() {
    }

    public static DiscoveryStrategy create(ResourceLoader resourceLoader, Bootstrap bootstrap, Set<Class<? extends Annotation>> initialBeanDefiningAnnotations) {
        if (Jandex.isJandexAvailable(resourceLoader)) {
            CommonLogger.LOG.usingJandex();
            try {
                return Jandex.createJandexDiscoveryStrategy(resourceLoader, bootstrap, initialBeanDefiningAnnotations);
            }
            catch (Exception e) {
                throw CommonLogger.LOG.unableToInstantiate("org.jboss.weld.environment.deployment.discovery.jandex.JandexDiscoveryStrategy", Arrays.toString(new Object[]{resourceLoader, bootstrap, initialBeanDefiningAnnotations}), e);
            }
        }
        return new ReflectionDiscoveryStrategy(resourceLoader, bootstrap, initialBeanDefiningAnnotations);
    }
}

