/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.beanManager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.solder.beanManager.BeanManagerProvider;
import org.jboss.solder.beanManager.BeanManagerUnavailableException;
import org.jboss.solder.util.Sortable;
import org.jboss.solder.util.service.ServiceLoader;

public class BeanManagerLocator {
    private volatile BeanManager beanManager;
    private volatile boolean lookupPerformed = false;
    private volatile BeanManagerProvider locatingProvider;
    private volatile List<BeanManagerProvider> providers;

    public BeanManager getBeanManager() {
        if (!this.lookupPerformed) {
            this.lookupBeanManager();
        }
        if (this.beanManager == null) {
            throw new BeanManagerUnavailableException(this.providers);
        }
        return this.beanManager;
    }

    public boolean isBeanManagerAvailable() {
        if (!this.lookupPerformed) {
            this.lookupBeanManager();
        }
        return this.beanManager != null;
    }

    public BeanManagerProvider getLocatingProvider() {
        return this.locatingProvider;
    }

    private synchronized void lookupBeanManager() {
        if (!this.lookupPerformed) {
            List<BeanManagerProvider> providers = this.loadServices();
            Collections.sort(providers, new Sortable.Comparator());
            for (BeanManagerProvider provider : providers) {
                this.beanManager = provider.getBeanManager();
                if (this.beanManager == null) continue;
                this.locatingProvider = provider;
                break;
            }
            this.providers = providers;
            this.lookupPerformed = true;
        }
    }

    private List<BeanManagerProvider> loadServices() {
        ArrayList<BeanManagerProvider> providers = new ArrayList<BeanManagerProvider>();
        Iterator<BeanManagerProvider> it = ServiceLoader.load(BeanManagerProvider.class).iterator();
        while (it.hasNext()) {
            providers.add(it.next());
        }
        return providers;
    }
}

