/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.registry.local;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.context.ApplicationScoped;
import org.guvnor.ala.registry.RuntimeRegistry;
import org.guvnor.ala.registry.local.utils.PageSortUtils;
import org.guvnor.ala.runtime.Runtime;
import org.guvnor.ala.runtime.RuntimeId;
import org.guvnor.ala.runtime.providers.Provider;
import org.guvnor.ala.runtime.providers.ProviderId;
import org.guvnor.ala.runtime.providers.ProviderType;
import org.uberfire.commons.validation.PortablePreconditions;

@ApplicationScoped
public class InMemoryRuntimeRegistry
implements RuntimeRegistry {
    private final Map<String, ProviderType> providerTypes = new ConcurrentHashMap<String, ProviderType>();
    private final Map<String, Provider> providers = new ConcurrentHashMap<String, Provider>();
    private final Map<ProviderType, List<Provider>> providersByType = new ConcurrentHashMap<ProviderType, List<Provider>>();
    private final Map<ProviderType, List<Runtime>> runtimesByProviderType = new ConcurrentHashMap<ProviderType, List<Runtime>>();

    public void registerProviderType(ProviderType pt) {
        this.providerTypes.put(pt.getProviderTypeName(), pt);
    }

    public List<ProviderType> getProviderTypes(Integer page, Integer pageSize, String sort, boolean sortOrder) {
        Collection<ProviderType> values = this.providerTypes.values();
        return PageSortUtils.pageSort(values, (pt1, pt2) -> {
            switch (sort) {
                case "providerTypeName": {
                    return pt1.getProviderTypeName().compareTo(pt2.getProviderTypeName());
                }
                case "version": {
                    return pt1.getVersion().compareTo(pt2.getVersion());
                }
            }
            return pt1.toString().compareTo(pt2.toString());
        }, page, pageSize, sort, sortOrder);
    }

    public ProviderType getProviderType(String provider) {
        return this.providerTypes.get(provider);
    }

    public void unregisterProviderType(ProviderType providerType) {
        this.providerTypes.remove(providerType.getProviderTypeName());
    }

    public void registerProvider(Provider provider) {
        this.providers.put(provider.getId(), provider);
        if (this.providersByType.get(provider.getProviderType()) != null) {
            List<Provider> providersInType = this.providersByType.get(provider.getProviderType());
            for (Provider p : providersInType) {
                if (!p.getId().equals(provider.getId())) continue;
                providersInType.remove(p);
            }
        }
        this.providersByType.computeIfAbsent(provider.getProviderType(), providerType -> new CopyOnWriteArrayList()).add(provider);
    }

    public List<Provider> getProviders(Integer page, Integer pageSize, String sort, boolean sortOrder) {
        Collection<Provider> values = this.providers.values();
        return PageSortUtils.pageSort(values, (p1, p2) -> {
            switch (sort) {
                case "id": {
                    return p1.getId().compareTo(p2.getId());
                }
                case "providerTypeName": {
                    return p1.getProviderType().getProviderTypeName().compareTo(p2.getProviderType().getProviderTypeName());
                }
                case "version": {
                    return p1.getProviderType().getVersion().compareTo(p2.getProviderType().getVersion());
                }
            }
            return p1.toString().compareTo(p2.toString());
        }, page, pageSize, sort, sortOrder);
    }

    public List<Provider> getProvidersByType(ProviderType type) {
        return this.providersByType.getOrDefault(type, Collections.emptyList());
    }

    public Provider getProvider(String providerName) {
        return this.providers.get(providerName);
    }

    public void unregisterProvider(Provider provider) {
        List<Provider> filteredProviders = this.providersByType.get(provider.getProviderType());
        if (filteredProviders != null) {
            filteredProviders.remove(provider);
        }
        this.providers.remove(provider.getId());
    }

    public void unregisterProvider(String providerName) {
        for (Provider p : this.providers.values()) {
            if (!p.getId().equals(providerName)) continue;
            this.unregisterProvider(p);
        }
    }

    public void registerRuntime(Runtime runtime) {
        Provider provider = this.providers.get(runtime.getProviderId().getId());
        if (this.runtimesByProviderType.get(provider.getProviderType()) != null) {
            List<Runtime> runtimes = this.runtimesByProviderType.get(provider.getProviderType());
            for (Runtime r : runtimes) {
                if (!r.getId().equals(runtime.getId())) continue;
                runtimes.remove(r);
            }
        }
        this.runtimesByProviderType.computeIfAbsent(provider.getProviderType(), providerType -> new CopyOnWriteArrayList()).add(runtime);
    }

    public List<Runtime> getRuntimes(Integer page, Integer pageSize, String sort, boolean sortOrder) {
        ArrayList<Runtime> runtimes = new ArrayList<Runtime>();
        for (List<Runtime> rs : this.runtimesByProviderType.values()) {
            runtimes.addAll(rs);
        }
        return PageSortUtils.pageSort(runtimes, (r1, r2) -> {
            switch (sort) {
                case "id": {
                    return r1.getId().compareTo(r2.getId());
                }
                case "state": {
                    return r1.getState().getState().compareTo(r2.getState().getState());
                }
            }
            return r1.toString().compareTo(r2.toString());
        }, page, pageSize, sort, sortOrder);
    }

    public List<Runtime> getRuntimesByProvider(ProviderType providerType) {
        return new ArrayList<Runtime>((Collection)this.runtimesByProviderType.get(providerType));
    }

    public Runtime getRuntimeById(String id) {
        for (ProviderType pt : this.runtimesByProviderType.keySet()) {
            for (Runtime r : this.runtimesByProviderType.get(pt)) {
                if (!r.getId().equals(id)) continue;
                return r;
            }
        }
        return null;
    }

    public <T extends Provider> Optional<T> getProvider(ProviderId providerId, Class<T> clazz) {
        PortablePreconditions.checkNotNull((String)"providerId", (Object)providerId);
        PortablePreconditions.checkNotNull((String)"clazz", clazz);
        Provider value = this.providers.get(providerId.getId());
        return Optional.ofNullable(value).filter(provider -> clazz.isInstance(provider)).map(provider -> (Provider)clazz.cast(provider));
    }

    public void unregisterRuntime(RuntimeId runtime) {
        Provider provider = this.providers.get(runtime.getProviderId().getId());
        List<Runtime> filteredRuntimes = this.runtimesByProviderType.get(provider.getProviderType());
        if (filteredRuntimes != null) {
            filteredRuntimes.remove(runtime);
        }
    }
}

