/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.core;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.cache.LRUCache;
import org.guvnor.common.services.project.builder.events.InvalidateDMOProjectCacheEvent;
import org.guvnor.common.services.project.builder.service.BuildValidationHelper;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.services.backend.builder.JavaSourceFilter;
import org.kie.workbench.common.services.backend.builder.core.Builder;
import org.kie.workbench.common.services.backend.builder.core.LRUPomModelCache;
import org.kie.workbench.common.services.backend.builder.core.LRUProjectDependenciesClassLoaderCache;
import org.kie.workbench.common.services.backend.builder.core.NoBuilderFoundException;
import org.kie.workbench.common.services.backend.whitelist.PackageNameWhiteListServiceImpl;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.kie.workbench.common.services.shared.project.ProjectImportsService;
import org.kie.workbench.common.services.shared.whitelist.PackageNameWhiteListService;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.io.IOService;

@ApplicationScoped
public class LRUBuilderCache
extends LRUCache<Project, Builder> {
    private IOService ioService;
    private KieProjectService projectService;
    private ProjectImportsService importsService;
    private Instance<BuildValidationHelper> buildValidationHelperBeans;
    private LRUProjectDependenciesClassLoaderCache dependenciesClassLoaderCache;
    private LRUPomModelCache pomModelCache;
    private PackageNameWhiteListServiceImpl packageNameWhiteListService;
    private Instance<Predicate<String>> classFilterBeans;
    private final List<BuildValidationHelper> buildValidationHelpers = new ArrayList<BuildValidationHelper>();
    private final List<Predicate<String>> classFilters = new ArrayList<Predicate<String>>();

    public LRUBuilderCache() {
    }

    @Inject
    public LRUBuilderCache(@Named(value="ioStrategy") IOService ioService, KieProjectService projectService, ProjectImportsService importsService, @Any Instance<BuildValidationHelper> buildValidationHelperBeans, @Named(value="LRUProjectDependenciesClassLoaderCache") LRUProjectDependenciesClassLoaderCache dependenciesClassLoaderCache, @Named(value="LRUPomModelCache") LRUPomModelCache pomModelCache, PackageNameWhiteListService packageNameWhiteListService, @JavaSourceFilter Instance<Predicate<String>> classFilterBeans) {
        this.ioService = ioService;
        this.projectService = projectService;
        this.importsService = importsService;
        this.buildValidationHelperBeans = buildValidationHelperBeans;
        this.dependenciesClassLoaderCache = dependenciesClassLoaderCache;
        this.pomModelCache = pomModelCache;
        this.packageNameWhiteListService = (PackageNameWhiteListServiceImpl)packageNameWhiteListService;
        this.classFilterBeans = classFilterBeans;
    }

    @PostConstruct
    public void loadInstances() {
        StreamSupport.stream(this.buildValidationHelperBeans.spliterator(), false).collect(Collectors.toCollection(() -> this.buildValidationHelpers));
        StreamSupport.stream(this.classFilterBeans.spliterator(), false).collect(Collectors.toCollection(() -> this.classFilters));
    }

    @PreDestroy
    public void destroyInstances() {
        this.buildValidationHelpers.forEach(helper -> this.buildValidationHelperBeans.destroy(helper));
        this.classFilters.forEach(filter -> this.classFilterBeans.destroy(filter));
    }

    public synchronized void invalidateProjectCache(@Observes InvalidateDMOProjectCacheEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        Project project = event.getProject();
        if (project != null) {
            this.invalidateCache(project);
        }
    }

    public synchronized Builder assertBuilder(POM pom) throws NoBuilderFoundException {
        for (Project project : this.getKeys()) {
            if (!project.getPom().getGav().equals((Object)pom.getGav())) continue;
            return this.makeBuilder(project);
        }
        throw new NoBuilderFoundException();
    }

    public synchronized Builder assertBuilder(Project project) {
        return this.makeBuilder(project);
    }

    public synchronized Builder getBuilder(Project project) {
        return (Builder)this.getEntry(project);
    }

    private Builder makeBuilder(Project project) {
        Builder builder = (Builder)this.getEntry(project);
        if (builder == null) {
            builder = new Builder(project, this.ioService, this.projectService, this.importsService, this.buildValidationHelpers, this.dependenciesClassLoaderCache, this.pomModelCache, this.packageNameWhiteListService, this.createSingleClassFilterPredicate());
            this.setEntry(project, builder);
        }
        return builder;
    }

    private Predicate<String> createSingleClassFilterPredicate() {
        return this.classFilters.stream().reduce(o -> true, (p1, p2) -> p1.and(p2));
    }
}

