/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.drools.core.base.evaluators.TimeIntervalParser;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.validation.JavaFileNameValidator;
import org.kie.workbench.common.services.backend.validation.PackageNameValidator;
import org.kie.workbench.common.services.backend.validation.ProjectNameValidator;
import org.kie.workbench.common.services.shared.validation.CopyValidator;
import org.kie.workbench.common.services.shared.validation.DeleteValidator;
import org.kie.workbench.common.services.shared.validation.SaveValidator;
import org.kie.workbench.common.services.shared.validation.ValidationService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.editor.commons.backend.validation.ValidationUtils;

@Service
@ApplicationScoped
public class ValidationServiceImpl
implements ValidationService {
    private org.uberfire.ext.editor.commons.service.ValidationService validationService;
    private PackageNameValidator packageNameValidator;
    private ProjectNameValidator projectNameValidator;
    private JavaFileNameValidator javaFileNameValidator;
    private Collection<SaveValidator> saveValidators = new ArrayList<SaveValidator>();
    private Collection<CopyValidator> copyValidators = new ArrayList<CopyValidator>();
    private Collection<DeleteValidator> deleteValidators = new ArrayList<DeleteValidator>();

    public ValidationServiceImpl() {
    }

    @Inject
    public ValidationServiceImpl(org.uberfire.ext.editor.commons.service.ValidationService validationService, PackageNameValidator packageNameValidator, ProjectNameValidator projectNameValidator, JavaFileNameValidator javaFileNameValidator, Instance<SaveValidator<?>> saveValidatorInstance, Instance<CopyValidator<?>> copyValidatorInstance, Instance<DeleteValidator<?>> deleteValidatorInstance) {
        this.validationService = validationService;
        this.packageNameValidator = packageNameValidator;
        this.projectNameValidator = projectNameValidator;
        this.javaFileNameValidator = javaFileNameValidator;
        saveValidatorInstance.forEach(this.saveValidators::add);
        copyValidatorInstance.forEach(this.copyValidators::add);
        deleteValidatorInstance.forEach(this.deleteValidators::add);
    }

    public boolean isProjectNameValid(String projectName) {
        return this.projectNameValidator.isValid(projectName);
    }

    public boolean isPackageNameValid(String packageName) {
        return this.packageNameValidator.isValid(packageName);
    }

    public boolean isFileNameValid(Path path, String fileName) {
        return this.validationService.isFileNameValid(path, fileName);
    }

    public boolean isJavaFileNameValid(String fileName) {
        return this.javaFileNameValidator.isValid(fileName);
    }

    public boolean isFileNameValid(String fileName) {
        return this.validationService.isFileNameValid(fileName);
    }

    public Map<String, Boolean> evaluateJavaIdentifiers(String[] identifiers) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(identifiers.length);
        if (identifiers != null && identifiers.length > 0) {
            for (String s : identifiers) {
                result.put(s, ValidationUtils.isJavaIdentifier((String)s));
            }
        }
        return result;
    }

    public Map<String, Boolean> evaluateMavenIdentifiers(String[] identifiers) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(identifiers.length);
        if (identifiers != null && identifiers.length > 0) {
            for (String s : identifiers) {
                result.put(s, ValidationUtils.isArtifactIdentifier((String)s));
            }
        }
        return result;
    }

    public boolean isTimerIntervalValid(String timerInterval) {
        try {
            TimeIntervalParser.parse((String)timerInterval);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public boolean validate(POM pom) {
        PortablePreconditions.checkNotNull((String)"pom", (Object)pom);
        String name = pom.getName();
        String groupId = pom.getGav().getGroupId();
        String artifactId = pom.getGav().getArtifactId();
        String version = pom.getGav().getVersion();
        boolean validName = name != null && !name.isEmpty() && this.isProjectNameValid(name);
        boolean validGroupId = this.validateGroupId(groupId);
        boolean validArtifactId = this.validateArtifactId(artifactId);
        boolean validVersion = this.validateGAVVersion(version);
        return validName && validGroupId && validArtifactId && validVersion;
    }

    public boolean validateGroupId(String groupId) {
        String[] groupIdComponents = groupId == null ? new String[]{} : groupId.split("\\.", -1);
        boolean validGroupId = groupIdComponents.length != 0 && !this.evaluateMavenIdentifiers(groupIdComponents).containsValue(Boolean.FALSE);
        return validGroupId;
    }

    public boolean validateArtifactId(String artifactId) {
        String[] artifactIdComponents = artifactId == null ? new String[]{} : artifactId.split("\\.", -1);
        boolean validArtifactId = artifactIdComponents.length != 0 && !this.evaluateMavenIdentifiers(artifactIdComponents).containsValue(Boolean.FALSE);
        return validArtifactId;
    }

    public boolean validateGAVVersion(String version) {
        boolean validVersion = version != null && !version.isEmpty() && version.matches("^[a-zA-Z0-9\\.\\-_]+$");
        return validVersion;
    }

    public <T> Collection<ValidationMessage> validateForSave(Path path, T content) {
        return this.saveValidators.stream().filter(v -> v.accept(path)).flatMap(c -> c.validate(path, content).stream()).collect(Collectors.toList());
    }

    public <T> Collection<ValidationMessage> validateForCopy(Path path, T content) {
        return this.copyValidators.stream().filter(v -> v.accept(path)).flatMap(c -> c.validate(path, content).stream()).collect(Collectors.toList());
    }

    public Collection<ValidationMessage> validateForCopy(Path path) {
        return this.copyValidators.stream().filter(v -> v.accept(path)).flatMap(c -> c.validate(path).stream()).collect(Collectors.toList());
    }

    public <T> Collection<ValidationMessage> validateForDelete(Path path, T content) {
        return this.deleteValidators.stream().filter(v -> v.accept(path)).flatMap(c -> c.validate(path, content).stream()).collect(Collectors.toList());
    }

    public Collection<ValidationMessage> validateForDelete(Path path) {
        return this.deleteValidators.stream().filter(v -> v.accept(path)).flatMap(c -> c.validate(path).stream()).collect(Collectors.toList());
    }
}

