/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import javax.measure.unit.Unit;
import org.apache.sis.internal.util.Cloner;
import org.apache.sis.parameter.DefaultParameterValue;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterValue;

final class UnmodifiableParameterValue<T>
extends DefaultParameterValue<T> {
    private static final long serialVersionUID = -4760030766220872555L;
    private static final WeakHashSet<UnmodifiableParameterValue> POOL = new WeakHashSet<UnmodifiableParameterValue>(UnmodifiableParameterValue.class);

    private UnmodifiableParameterValue(ParameterValue<T> parameterValue) {
        super(parameterValue);
    }

    static <T> UnmodifiableParameterValue<T> create(ParameterValue<T> parameterValue) {
        if (parameterValue == null || parameterValue instanceof UnmodifiableParameterValue) {
            return (UnmodifiableParameterValue)parameterValue;
        }
        return POOL.unique(new UnmodifiableParameterValue<T>(parameterValue));
    }

    @Override
    public T getValue() {
        Object t = super.getValue();
        if (t instanceof Cloneable) {
            try {
                t = this.getDescriptor().getValueClass().cast(Cloner.cloneIfPublic(t));
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new UnsupportedOperationException(Errors.format((short)13, t.getClass()), cloneNotSupportedException);
            }
        }
        return t;
    }

    @Override
    protected void setValue(Object object, Unit<?> unit) {
        throw new UnsupportedOperationException(Errors.format((short)123, this.getClass()));
    }

    @Override
    public DefaultParameterValue<T> clone() {
        return new DefaultParameterValue(this);
    }
}

