/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.util.Iterator;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

final class NameIterator
implements Iterator<ReferenceIdentifier> {
    private ReferenceIdentifier next;
    private final Iterator<GenericName> alias;

    NameIterator(IdentifiedObject identifiedObject) {
        this.alias = identifiedObject.getAlias().iterator();
        this.next = identifiedObject.getName();
        if (this.next == null || this.next == NilReferencingObject.UNNAMED) {
            this.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public ReferenceIdentifier next() {
        ReferenceIdentifier referenceIdentifier = this.next;
        while (this.alias.hasNext()) {
            GenericName genericName = this.alias.next();
            if (!(genericName instanceof ReferenceIdentifier)) continue;
            this.next = (ReferenceIdentifier)((Object)genericName);
            return referenceIdentifier;
        }
        this.next = null;
        return referenceIdentifier;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static int count(IdentifiedObject identifiedObject) {
        int n = 0;
        NameIterator nameIterator = new NameIterator(identifiedObject);
        while (nameIterator.hasNext()) {
            nameIterator.next();
            ++n;
        }
        return n;
    }
}

