/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import java.util.Map;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.referencing.Legacy;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.referencing.WKTUtilities;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;

@XmlType(name="GeodeticCRSType", propOrder={"ellipsoidalCS", "cartesianCS", "sphericalCS", "datum"})
@XmlRootElement(name="GeodeticCRS")
class DefaultGeodeticCRS
extends AbstractCRS
implements GeodeticCRS {
    private static final long serialVersionUID = -6205678223972395910L;
    @XmlElement(name="geodeticDatum", required=true)
    private final GeodeticDatum datum;

    DefaultGeodeticCRS(Map<String, ?> map, GeodeticDatum geodeticDatum, CoordinateSystem coordinateSystem) {
        super(map, coordinateSystem);
        ArgumentChecks.ensureNonNull("datum", geodeticDatum);
        this.datum = geodeticDatum;
    }

    protected DefaultGeodeticCRS(GeodeticCRS geodeticCRS) {
        super(geodeticCRS);
        this.datum = geodeticCRS.getDatum();
    }

    public Class<? extends GeodeticCRS> getInterface() {
        return GeodeticCRS.class;
    }

    @Override
    public GeodeticDatum getDatum() {
        return this.datum;
    }

    @Override
    AbstractCRS createSameType(Map<String, ?> map, CoordinateSystem coordinateSystem) {
        return new DefaultGeodeticCRS(map, this.datum, coordinateSystem);
    }

    @Override
    protected String formatTo(Formatter formatter) {
        boolean bl;
        WKTUtilities.appendName(this, formatter, null);
        Convention convention = formatter.getConvention();
        boolean bl2 = convention.majorVersion() == 1;
        CoordinateSystem coordinateSystem = this.getCoordinateSystem();
        GeodeticDatum geodeticDatum = this.getDatum();
        formatter.newLine();
        formatter.append(WKTUtilities.toFormattable(geodeticDatum));
        formatter.newLine();
        PrimeMeridian primeMeridian = geodeticDatum.getPrimeMeridian();
        Unit<Angle> unit = AxisDirections.getAngularUnit(coordinateSystem, null);
        if (convention != Convention.WKT2_SIMPLIFIED || ReferencingUtilities.getGreenwichLongitude(primeMeridian, (Unit<Angle>)NonSI.DEGREE_ANGLE) != 0.0) {
            Unit<Angle> unit2 = formatter.addContextualUnit(unit);
            formatter.indent(1);
            formatter.append(WKTUtilities.toFormattable(primeMeridian));
            formatter.indent(-1);
            formatter.newLine();
            formatter.restoreContextualUnit(unit, unit2);
        }
        if (bl2) {
            if (!(coordinateSystem instanceof EllipsoidalCS)) {
                if (coordinateSystem instanceof CartesianCS) {
                    coordinateSystem = Legacy.forGeocentricCRS((CartesianCS)coordinateSystem, true);
                } else {
                    formatter.setInvalidWKT(coordinateSystem, null);
                }
            }
            bl = false;
        } else {
            bl = DefaultGeodeticCRS.isBaseCRS(formatter);
        }
        if (!bl || convention == Convention.INTERNAL) {
            this.formatCS(formatter, coordinateSystem, ReferencingUtilities.getUnit(coordinateSystem), bl2);
        } else if (convention.isSimplified()) {
            formatter.append(formatter.toContextualUnit(unit));
        }
        if (bl2) {
            return coordinateSystem instanceof EllipsoidalCS ? "GeogCS" : "GeocCS";
        }
        return bl ? "BaseGeodCRS" : formatter.shortOrLong("GeodCRS", "GeodeticCRS");
    }

    DefaultGeodeticCRS() {
        this.datum = null;
    }

    @XmlElement(name="ellipsoidalCS")
    private EllipsoidalCS getEllipsoidalCS() {
        return this.getCoordinateSystem(EllipsoidalCS.class);
    }

    @XmlElement(name="cartesianCS")
    private CartesianCS getCartesianCS() {
        return this.getCoordinateSystem(CartesianCS.class);
    }

    @XmlElement(name="sphericalCS")
    private SphericalCS getSphericalCS() {
        return this.getCoordinateSystem(SphericalCS.class);
    }

    private void setEllipsoidalCS(EllipsoidalCS ellipsoidalCS) {
        super.setCoordinateSystem("ellipsoidalCS", ellipsoidalCS);
    }

    private void setCartesianCS(CartesianCS cartesianCS) {
        super.setCoordinateSystem("cartesianCS", cartesianCS);
    }

    private void setSphericalCS(SphericalCS sphericalCS) {
        super.setCoordinateSystem("sphericalCS", sphericalCS);
    }
}

