/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Map;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;

@XmlType(name="AffineCSType")
@XmlRootElement(name="AffineCS")
public class DefaultAffineCS
extends AbstractCS
implements AffineCS {
    private static final long serialVersionUID = 7977674229369042440L;

    DefaultAffineCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        super(map, coordinateSystemAxisArray);
    }

    public DefaultAffineCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2);
    }

    public DefaultAffineCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis, CoordinateSystemAxis coordinateSystemAxis2, CoordinateSystemAxis coordinateSystemAxis3) {
        super(map, coordinateSystemAxis, coordinateSystemAxis2, coordinateSystemAxis3);
    }

    protected DefaultAffineCS(AffineCS affineCS) {
        super(affineCS);
    }

    public static DefaultAffineCS castOrCopy(AffineCS affineCS) {
        if (affineCS instanceof CartesianCS) {
            return DefaultCartesianCS.castOrCopy((CartesianCS)affineCS);
        }
        return affineCS == null || affineCS instanceof DefaultAffineCS ? (DefaultAffineCS)affineCS : new DefaultAffineCS(affineCS);
    }

    @Override
    final int validateAxis(AxisDirection axisDirection, Unit<?> unit) {
        if (!AxisDirections.isSpatialOrUserDefined(axisDirection, true)) {
            return 1;
        }
        if (!Units.isLinear(unit) && !Unit.ONE.equals(unit)) {
            return 2;
        }
        return 0;
    }

    public Class<? extends AffineCS> getInterface() {
        return AffineCS.class;
    }

    @Override
    public DefaultAffineCS forConvention(AxesConvention axesConvention) {
        return (DefaultAffineCS)super.forConvention(axesConvention);
    }

    @Override
    AbstractCS createForAxes(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        switch (coordinateSystemAxisArray.length) {
            case 2: 
            case 3: {
                return new DefaultAffineCS(map, coordinateSystemAxisArray);
            }
        }
        throw DefaultAffineCS.unexpectedDimension(map, coordinateSystemAxisArray, 2);
    }

    DefaultAffineCS() {
    }
}

