/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.AxisDirections;
import org.apache.sis.internal.referencing.NilReferencingObject;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.cs.DirectionAlongMeridian;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;

@XmlType(name="CoordinateSystemAxisType", propOrder={"abbreviation", "direction", "minimum", "maximum", "rangeMeaning"})
@XmlRootElement(name="CoordinateSystemAxis")
public class DefaultCoordinateSystemAxis
extends AbstractIdentifiedObject
implements CoordinateSystemAxis {
    private static final long serialVersionUID = -7883614853277827689L;
    public static final String MINIMUM_VALUE_KEY = "minimumValue";
    public static final String MAXIMUM_VALUE_KEY = "maximumValue";
    public static final String RANGE_MEANING_KEY = "rangeMeaning";
    private static final Map<String, Object> ALIASES = new HashMap<String, Object>(12);
    private static final String[] ALIASES_XY;
    @XmlElement(name="axisAbbrev", required=true)
    private final String abbreviation;
    @XmlElement(name="axisDirection", required=true)
    private final AxisDirection direction;
    @XmlAttribute(name="uom", required=true)
    private final Unit<?> unit;
    private double minimumValue;
    private double maximumValue;
    @XmlElement
    private final RangeMeaning rangeMeaning;

    public DefaultCoordinateSystemAxis(Map<String, ?> map, String string, AxisDirection axisDirection, Unit<?> unit) {
        super(map);
        this.abbreviation = string;
        this.direction = axisDirection;
        this.unit = unit;
        ArgumentChecks.ensureNonEmpty("abbreviation", string);
        ArgumentChecks.ensureNonNull("direction", axisDirection);
        ArgumentChecks.ensureNonNull("unit", unit);
        Number number = Containers.property(map, MINIMUM_VALUE_KEY, Number.class);
        Number number2 = Containers.property(map, MAXIMUM_VALUE_KEY, Number.class);
        RangeMeaning rangeMeaning = Containers.property(map, RANGE_MEANING_KEY, RangeMeaning.class);
        if (number == null && number2 == null && rangeMeaning == null) {
            double d = Double.NEGATIVE_INFINITY;
            double d2 = Double.POSITIVE_INFINITY;
            if (Units.isAngular(unit)) {
                UnitConverter unitConverter = NonSI.DEGREE_ANGLE.getConverterTo(unit.asType(Angle.class));
                AxisDirection axisDirection2 = AxisDirections.absolute(axisDirection);
                if (axisDirection2.equals(AxisDirection.NORTH)) {
                    d = unitConverter.convert(-90.0);
                    d2 = unitConverter.convert(90.0);
                    rangeMeaning = RangeMeaning.EXACT;
                } else if (axisDirection2.equals(AxisDirection.EAST)) {
                    d = unitConverter.convert(-180.0);
                    d2 = unitConverter.convert(180.0);
                    rangeMeaning = RangeMeaning.WRAPAROUND;
                }
                if (d > d2) {
                    double d3 = d;
                    d = d2;
                    d2 = d3;
                }
            }
            this.minimumValue = d;
            this.maximumValue = d2;
        } else {
            this.minimumValue = number != null ? number.doubleValue() : Double.NEGATIVE_INFINITY;
            double d = this.maximumValue = number2 != null ? number2.doubleValue() : Double.POSITIVE_INFINITY;
            if (!(this.minimumValue < this.maximumValue)) {
                throw new IllegalArgumentException(Errors.getResources(map).getString((short)41, this.minimumValue, this.maximumValue));
            }
            if (this.minimumValue != Double.NEGATIVE_INFINITY || this.maximumValue != Double.POSITIVE_INFINITY) {
                ArgumentChecks.ensureNonNull(RANGE_MEANING_KEY, rangeMeaning);
            } else {
                rangeMeaning = null;
            }
        }
        this.rangeMeaning = rangeMeaning;
    }

    protected DefaultCoordinateSystemAxis(CoordinateSystemAxis coordinateSystemAxis) {
        super(coordinateSystemAxis);
        this.abbreviation = coordinateSystemAxis.getAbbreviation();
        this.direction = coordinateSystemAxis.getDirection();
        this.unit = coordinateSystemAxis.getUnit();
        this.minimumValue = coordinateSystemAxis.getMinimumValue();
        this.maximumValue = coordinateSystemAxis.getMaximumValue();
        this.rangeMeaning = coordinateSystemAxis.getRangeMeaning();
    }

    public static DefaultCoordinateSystemAxis castOrCopy(CoordinateSystemAxis coordinateSystemAxis) {
        return coordinateSystemAxis == null || coordinateSystemAxis instanceof DefaultCoordinateSystemAxis ? (DefaultCoordinateSystemAxis)coordinateSystemAxis : new DefaultCoordinateSystemAxis(coordinateSystemAxis);
    }

    public Class<? extends CoordinateSystemAxis> getInterface() {
        return CoordinateSystemAxis.class;
    }

    @Override
    public AxisDirection getDirection() {
        return this.direction;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    public Unit<?> getUnit() {
        return this.unit;
    }

    @Override
    public double getMinimumValue() {
        return this.minimumValue;
    }

    @Override
    public double getMaximumValue() {
        return this.maximumValue;
    }

    private static void outOfRange(String string, Double d) {
        Context.warningOccured(Context.current(), DefaultCoordinateSystemAxis.class, string, Errors.class, (short)47, string, d);
    }

    @Override
    public RangeMeaning getRangeMeaning() {
        return this.rangeMeaning;
    }

    @Override
    public boolean isHeuristicMatchForName(String string) {
        if (super.isHeuristicMatchForName(string)) {
            return true;
        }
        Object object = ALIASES.get(CharSequences.trimWhitespaces(string).toLowerCase(Locale.US));
        return object != null && object == ALIASES.get(CharSequences.trimWhitespaces(this.getName().getCode()).toLowerCase(Locale.US));
    }

    private static boolean isHeuristicMatchForNameXY(String string, String string2) {
        int n;
        if ((string = CharSequences.trimWhitespaces(string)).length() == 1 && (n = Character.toLowerCase(string.charAt(0)) - 120) >= 0 && n <= 1 && !(string2 = CharSequences.trimWhitespaces(string2)).isEmpty()) {
            do {
                if (!string2.regionMatches(true, 0, ALIASES_XY[n], 0, string2.length())) continue;
                return true;
            } while ((n += 2) < ALIASES_XY.length);
        }
        return false;
    }

    private boolean equalsIgnoreMetadata(CoordinateSystemAxis coordinateSystemAxis, boolean bl) {
        return Objects.equals(this.getUnit(), coordinateSystemAxis.getUnit()) && Objects.equals(this.getDirection(), coordinateSystemAxis.getDirection()) && (!bl || Double.doubleToLongBits(this.getMinimumValue()) == Double.doubleToLongBits(coordinateSystemAxis.getMinimumValue()) && Double.doubleToLongBits(this.getMaximumValue()) == Double.doubleToLongBits(coordinateSystemAxis.getMaximumValue()));
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        String string;
        String string2;
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        switch (comparisonMode) {
            case STRICT: {
                DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = (DefaultCoordinateSystemAxis)object;
                return Objects.equals(this.unit, defaultCoordinateSystemAxis.unit) && Objects.equals(this.direction, defaultCoordinateSystemAxis.direction) && Objects.equals(this.abbreviation, defaultCoordinateSystemAxis.abbreviation) && Objects.equals(this.rangeMeaning, defaultCoordinateSystemAxis.rangeMeaning) && Double.doubleToLongBits(this.minimumValue) == Double.doubleToLongBits(defaultCoordinateSystemAxis.minimumValue) && Double.doubleToLongBits(this.maximumValue) == Double.doubleToLongBits(defaultCoordinateSystemAxis.maximumValue);
            }
            case BY_CONTRACT: {
                CoordinateSystemAxis coordinateSystemAxis = (CoordinateSystemAxis)object;
                return this.equalsIgnoreMetadata(coordinateSystemAxis, true) && Objects.equals(this.getAbbreviation(), coordinateSystemAxis.getAbbreviation()) && Objects.equals(this.getRangeMeaning(), coordinateSystemAxis.getRangeMeaning());
            }
        }
        CoordinateSystemAxis coordinateSystemAxis = (CoordinateSystemAxis)object;
        if (!this.equalsIgnoreMetadata(coordinateSystemAxis, RangeMeaning.WRAPAROUND.equals(this.getRangeMeaning()) && RangeMeaning.WRAPAROUND.equals(coordinateSystemAxis.getRangeMeaning()))) {
            return false;
        }
        ReferenceIdentifier referenceIdentifier = coordinateSystemAxis.getName();
        return referenceIdentifier == NilReferencingObject.UNNAMED || this.isHeuristicMatchForName(string2 = referenceIdentifier.getCode()) || (referenceIdentifier = this.getName()) == NilReferencingObject.UNNAMED || IdentifiedObjects.isHeuristicMatchForName(coordinateSystemAxis, string = referenceIdentifier.getCode()) || DefaultCoordinateSystemAxis.isHeuristicMatchForNameXY(string2, string) || DefaultCoordinateSystemAxis.isHeuristicMatchForNameXY(string, string2);
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hashCode(this.unit) + (long)Objects.hashCode(this.direction) + Double.doubleToLongBits(this.minimumValue) + 31L * Double.doubleToLongBits(this.maximumValue);
    }

    private static CoordinateSystem getEnclosingCS(Formatter formatter) {
        FormattableObject formattableObject = formatter.getEnclosingElement(1);
        if (formattableObject instanceof CoordinateReferenceSystem) {
            return ((CoordinateReferenceSystem)((Object)formattableObject)).getCoordinateSystem();
        }
        if (formattableObject instanceof CoordinateSystem) {
            return (CoordinateSystem)((Object)formattableObject);
        }
        return null;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        Object object;
        Object object2;
        Convention convention = formatter.getConvention();
        boolean bl = convention.majorVersion() == 1;
        boolean bl2 = convention == Convention.INTERNAL;
        CoordinateSystem coordinateSystem = DefaultCoordinateSystemAxis.getEnclosingCS(formatter);
        AxisDirection axisDirection = this.getDirection();
        String string = IdentifiedObjects.getName(this, formatter.getNameAuthority());
        if (string == null) {
            string = IdentifiedObjects.getName(this, null);
        }
        if (string != null && !bl2) {
            object2 = string;
            string = formatter.getTransliterator().toShortAxisName(coordinateSystem, axisDirection, string);
            if (string == null && bl) {
                string = object2;
            }
        }
        if (!bl && (object2 = formatter.getTransliterator().toLatinAbbreviation(coordinateSystem, axisDirection, this.getAbbreviation())) != null && !((String)object2).equals(string)) {
            object = new StringBuilder();
            if (string != null) {
                ((StringBuilder)object).append(string).append(' ');
            }
            string = ((StringBuilder)object).append('(').append((String)object2).append(')').toString();
        }
        formatter.append(string, ElementKind.AXIS);
        object2 = null;
        if (!bl && AxisDirections.isUserDefined(axisDirection) && (object2 = DirectionAlongMeridian.parse(axisDirection)) != null) {
            axisDirection = ((DirectionAlongMeridian)object2).baseDirection;
        }
        formatter.append(axisDirection);
        formatter.append((FormattableObject)object2);
        if (!bl) {
            if (convention == Convention.WKT2 && coordinateSystem != null) {
                object = Order.create(coordinateSystem, this);
                if (object != null) {
                    formatter.append((FormattableObject)object);
                } else {
                    formatter.setInvalidWKT(coordinateSystem, null);
                }
            }
            if (!formatter.hasContextualUnit(1)) {
                formatter.append(this.getUnit());
            }
        }
        return "Axis";
    }

    private DefaultCoordinateSystemAxis() {
        super(NilReferencingObject.INSTANCE);
        this.abbreviation = null;
        this.direction = null;
        this.unit = null;
        this.rangeMeaning = null;
        this.minimumValue = Double.NEGATIVE_INFINITY;
        this.maximumValue = Double.POSITIVE_INFINITY;
    }

    @XmlElement(name="minimumValue")
    private Double getMinimum() {
        return this.minimumValue != Double.NEGATIVE_INFINITY ? Double.valueOf(this.minimumValue) : null;
    }

    private void setMinimum(Double d) {
        if (this.minimumValue == Double.NEGATIVE_INFINITY) {
            double d2 = d;
            if (d2 < this.maximumValue) {
                this.minimumValue = d2;
            } else {
                DefaultCoordinateSystemAxis.outOfRange(MINIMUM_VALUE_KEY, d);
            }
        } else {
            ReferencingUtilities.propertyAlreadySet(DefaultCoordinateSystemAxis.class, "setMinimum", MINIMUM_VALUE_KEY);
        }
    }

    @XmlElement(name="maximumValue")
    private Double getMaximum() {
        return this.maximumValue != Double.POSITIVE_INFINITY ? Double.valueOf(this.maximumValue) : null;
    }

    private void setMaximum(Double d) {
        if (this.maximumValue == Double.POSITIVE_INFINITY) {
            double d2 = d;
            if (d2 > this.minimumValue) {
                this.maximumValue = d2;
            } else {
                DefaultCoordinateSystemAxis.outOfRange(MAXIMUM_VALUE_KEY, d);
            }
        } else {
            ReferencingUtilities.propertyAlreadySet(DefaultCoordinateSystemAxis.class, "setMaximum", MAXIMUM_VALUE_KEY);
        }
    }

    static {
        Boolean bl = Boolean.TRUE;
        Boolean bl2 = Boolean.FALSE;
        ALIASES.put("lat", bl);
        ALIASES.put("latitude", bl);
        ALIASES.put("geodetic latitude", bl);
        ALIASES.put("lon", bl2);
        ALIASES.put("long", bl2);
        ALIASES.put("longitude", bl2);
        ALIASES.put("geodetic longitude", bl2);
        ALIASES_XY = new String[]{"Easting", "Northing", "Westing", "Southing"};
    }

    private static final class Order
    extends FormattableObject {
        private final int index;

        static Order create(CoordinateSystem coordinateSystem, DefaultCoordinateSystemAxis defaultCoordinateSystemAxis) {
            Order order = null;
            int n = coordinateSystem.getDimension();
            int n2 = 0;
            while (n2 < n) {
                if (coordinateSystem.getAxis(n2++) != defaultCoordinateSystemAxis) continue;
                if (order == null) {
                    order = new Order(n2);
                    continue;
                }
                return null;
            }
            return order;
        }

        private Order(int n) {
            this.index = n;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            formatter.append(this.index);
            return "Order";
        }
    }
}

