/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.api;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.UnsupportedCriterium;
import org.picketlink.idm.api.User;
import org.picketlink.idm.impl.helper.Tools;
import org.picketlink.idm.spi.search.IdentityObjectSearchCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitySearchCriteriaImpl
implements IdentitySearchCriteria,
IdentityObjectSearchCriteria,
Serializable {
    private boolean sorted = false;
    private String sortByName;
    private boolean ascending = true;
    private boolean paged = false;
    private int firstResult;
    private int maxResults;
    private boolean filtered = false;
    private final Map<String, String[]> attributes = new HashMap<String, String[]>();
    private String filter;

    public IdentitySearchCriteriaImpl() {
    }

    public IdentitySearchCriteriaImpl(IdentityObjectSearchCriteria criteria) {
        this.sorted = criteria.isSorted();
        this.sortByName = criteria.getSortAttributeName();
        this.ascending = criteria.isAscending();
        this.filtered = criteria.isFiltered();
        this.filter = criteria.getFilter();
        this.attributes.putAll(criteria.getValues());
        this.paged = criteria.isPaged();
        this.firstResult = criteria.getFirstResult();
        this.maxResults = criteria.getMaxResults();
    }

    public IdentitySearchCriteria sort(SortOrder order) throws UnsupportedCriterium {
        this.sorted = true;
        this.ascending = order.equals((Object)SortOrder.ASCENDING);
        return this;
    }

    public IdentitySearchCriteria sortAttributeName(String name) throws UnsupportedCriterium {
        this.sorted = true;
        this.sortByName = name;
        return this;
    }

    public IdentitySearchCriteria page(int firstResult, int maxResults) throws UnsupportedCriterium {
        this.paged = true;
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        return this;
    }

    public IdentitySearchCriteria attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedCriterium {
        if (attributeName == null) {
            throw new IllegalArgumentException("Attribute name is null");
        }
        if (attributeValue == null) {
            throw new IllegalArgumentException("Attribute values are null");
        }
        this.filtered = true;
        this.attributes.put(attributeName, attributeValue);
        return this;
    }

    public IdentitySearchCriteria nameFilter(String filter) throws UnsupportedCriterium {
        if (filter == null) {
            throw new IllegalArgumentException("ID filter is null");
        }
        this.filter = filter;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public String getSortAttributeName() {
        return this.sortByName;
    }

    public boolean isPaged() {
        return this.paged;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public Map<String, String[]> getValues() {
        return this.attributes;
    }

    public void setPaged(boolean paged) {
        this.paged = paged;
    }

    public static <T extends IdentityType> List<T> applyCriteria(IdentitySession identitySession, IdentityObjectSearchCriteria criteria, List<T> types) throws Exception {
        if (criteria.isFiltered()) {
            if (criteria.getFilter() != null) {
                IdentitySearchCriteriaImpl.filterByIdFilter(types, criteria.getFilter());
            }
            if (criteria.getValues() != null && criteria.getValues().size() > 0) {
                IdentitySearchCriteriaImpl.filterByAttributesValues(identitySession, types, criteria.getValues());
            }
        }
        if (criteria.isSorted()) {
            if (criteria.getSortAttributeName() != null) {
                IdentitySearchCriteriaImpl.sortByAttributeName(identitySession, types, criteria.getSortAttributeName(), criteria.isAscending());
            } else {
                IdentitySearchCriteriaImpl.sortByName(types, criteria.isAscending());
            }
        }
        List<T> results = types;
        if (criteria.isPaged()) {
            results = IdentitySearchCriteriaImpl.cutPageFromResults(results, criteria);
        }
        return results;
    }

    private static void filterByAttributesValues(IdentitySession identitySession, Collection<? extends IdentityType> types, Map<String, String[]> attrs) throws Exception {
        HashSet<IdentityType> toRemove = new HashSet<IdentityType>();
        block0: for (IdentityType identityType : types) {
            Map presentAttrs = identitySession.getAttributesManager().getAttributes(identityType);
            block1: for (Map.Entry<String, String[]> entry : attrs.entrySet()) {
                if (presentAttrs.containsKey(entry.getKey())) {
                    HashSet<Object> given = new HashSet<Object>(Arrays.asList((Object[])entry.getValue()));
                    Attribute attr = (Attribute)presentAttrs.get(entry.getKey());
                    Collection<Object> present = null;
                    present = attr != null ? attr.getValues() : Collections.emptySet();
                    for (String string : given) {
                        if (present.contains(string)) continue;
                        toRemove.add(identityType);
                        continue block1;
                    }
                    continue;
                }
                toRemove.add(identityType);
                continue block0;
            }
        }
        for (IdentityType identityType : toRemove) {
            types.remove(identityType);
        }
    }

    private static void filterByIdFilter(List<? extends IdentityType> types, String filter) throws Exception {
        HashSet<IdentityType> toRemove = new HashSet<IdentityType>();
        String regex = Tools.wildcardToRegex(filter);
        for (IdentityType identityType : types) {
            String id = null;
            if (identityType instanceof User) {
                id = identityType.getKey();
            } else if (identityType instanceof Group) {
                id = ((Group)identityType).getName();
            } else {
                throw new IllegalStateException();
            }
            if (id.matches(regex)) continue;
            toRemove.add(identityType);
        }
        for (IdentityType identityType : toRemove) {
            types.remove(identityType);
        }
    }

    private static <T extends IdentityType> void sortByName(List<T> objects, final boolean ascending) {
        Collections.sort(objects, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 instanceof User && o2 instanceof User) {
                    if (ascending) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                    return o2.getKey().compareTo(o1.getKey());
                }
                Group g1 = (Group)o1;
                Group g2 = (Group)o2;
                if (ascending) {
                    return g1.getName().compareTo(g2.getName());
                }
                return g2.getName().compareTo(g1.getName());
            }
        });
    }

    private static <T extends IdentityType> void sortByAttributeName(IdentitySession identitySession, List<T> objects, String attributeName, final boolean ascending) throws Exception {
        final HashMap<IdentityType, String> attributes = new HashMap<IdentityType, String>();
        for (IdentityType object : objects) {
            Attribute attr = identitySession.getAttributesManager().getAttribute(object, attributeName);
            if (attr != null && attr.getValue() != null) {
                attributes.put(object, attr.getValue().toString());
                continue;
            }
            attributes.put(object, "");
        }
        Collections.sort(objects, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                String a1 = (String)attributes.get(o1);
                String a2 = (String)attributes.get(o2);
                if (ascending) {
                    return a1.compareTo(a2);
                }
                return a2.compareTo(a1);
            }
        });
    }

    private static <T extends IdentityType> List<T> cutPageFromResults(List<T> objects, IdentityObjectSearchCriteria criteria) {
        LinkedList<T> results = new LinkedList<T>();
        if (criteria.getMaxResults() == 0) {
            for (int i = criteria.getFirstResult(); i < objects.size(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        } else {
            for (int i = criteria.getFirstResult(); i < criteria.getFirstResult() + criteria.getMaxResults(); ++i) {
                if (i >= objects.size()) continue;
                results.add(objects.get(i));
            }
        }
        return results;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentitySearchCriteriaImpl that = (IdentitySearchCriteriaImpl)o;
        if (this.ascending != that.ascending) {
            return false;
        }
        if (this.filtered != that.filtered) {
            return false;
        }
        if (this.firstResult != that.firstResult) {
            return false;
        }
        if (this.maxResults != that.maxResults) {
            return false;
        }
        if (this.paged != that.paged) {
            return false;
        }
        if (this.sorted != that.sorted) {
            return false;
        }
        if (this.attributes != null ? !((Object)this.attributes).equals(that.attributes) : that.attributes != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        return !(this.sortByName != null ? !this.sortByName.equals(that.sortByName) : that.sortByName != null);
    }

    public int hashCode() {
        int result = this.sorted ? 1 : 0;
        result = 31 * result + (this.sortByName != null ? this.sortByName.hashCode() : 0);
        result = 31 * result + (this.ascending ? 1 : 0);
        result = 31 * result + (this.paged ? 1 : 0);
        result = 31 * result + this.firstResult;
        result = 31 * result + this.maxResults;
        result = 31 * result + (this.filtered ? 1 : 0);
        result = 31 * result + (this.attributes != null ? ((Object)this.attributes).hashCode() : 0);
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        return result;
    }

    public String toString() {
        return Integer.toString(this.hashCode());
    }
}

