/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import java.util.Map;
import org.apache.helix.task.WorkflowConfig;

public class JobQueue
extends WorkflowConfig {
    public static final String CAPACITY = "CAPACITY";
    private final String _name;
    private final int _capacity;

    private JobQueue(String name, int capacity, WorkflowConfig config) {
        super(config.getJobDag(), config.getTargetState(), config.getExpiry(), config.isTerminable(), config.getScheduleConfig());
        this._name = name;
        this._capacity = capacity;
    }

    public String getName() {
        return this._name;
    }

    public int getCapacity() {
        return this._capacity;
    }

    @Override
    public Map<String, String> getResourceConfigMap() throws Exception {
        Map<String, String> cfgMap = super.getResourceConfigMap();
        cfgMap.put(CAPACITY, String.valueOf(this._capacity));
        return cfgMap;
    }

    public static class Builder {
        private WorkflowConfig.Builder _builder;
        private final String _name;
        private int _capacity = Integer.MAX_VALUE;

        public Builder(String name) {
            this._builder = new WorkflowConfig.Builder();
            this._name = name;
        }

        public Builder expiry(long expiry) {
            this._builder.setExpiry(expiry);
            return this;
        }

        public Builder capacity(int capacity) {
            this._capacity = capacity;
            return this;
        }

        public Builder fromMap(Map<String, String> cfg) {
            this._builder = WorkflowConfig.Builder.fromMap(cfg);
            if (cfg.containsKey(JobQueue.CAPACITY)) {
                this._capacity = Integer.parseInt(cfg.get(JobQueue.CAPACITY));
            }
            return this;
        }

        public JobQueue build() {
            this._builder.setTerminable(false);
            WorkflowConfig workflowConfig = this._builder.build();
            return new JobQueue(this._name, this._capacity, workflowConfig);
        }
    }
}

