/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.rpc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ConversionResult
implements Serializable {
    private static final long serialVersionUID = 540L;
    private List<ConversionAsset> newAssets = new ArrayList<ConversionAsset>();
    private List<ConversionMessage> messages = new ArrayList<ConversionMessage>();

    public boolean isConverted() {
        for (ConversionMessage message : this.messages) {
            if (message.getMessageType() != ConversionMessageType.ERROR) continue;
            return false;
        }
        return true;
    }

    public void addNewAsset(ConversionAsset newAsset) {
        this.newAssets.add(newAsset);
    }

    public List<ConversionAsset> getNewAssets() {
        return this.newAssets;
    }

    public void addMessage(String message, ConversionMessageType messageType) {
        this.messages.add(new ConversionMessage(message, messageType));
    }

    public List<ConversionMessage> getMessages() {
        return this.messages;
    }

    public List<ConversionMessage> getMessages(ConversionMessageType messageType) {
        ArrayList<ConversionMessage> messages = new ArrayList<ConversionMessage>();
        for (ConversionMessage message : this.messages) {
            if (message.getMessageType() != messageType) continue;
            messages.add(message);
        }
        return messages;
    }

    public static class ConversionAsset
    implements Serializable {
        private static final long serialVersionUID = 540L;
        private String uuid;
        private String format;

        public ConversionAsset() {
        }

        public ConversionAsset(String uuid, String format) {
            this.uuid = uuid;
            this.format = format;
        }

        public String getUUID() {
            return this.uuid;
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class ConversionMessage
    implements Serializable {
        private static final long serialVersionUID = 540L;
        private String message;
        private ConversionMessageType messageType;

        public ConversionMessage() {
        }

        public ConversionMessage(String message, ConversionMessageType messageType) {
            this.message = message;
            this.messageType = messageType;
        }

        public String getMessage() {
            return this.message;
        }

        public ConversionMessageType getMessageType() {
            return this.messageType;
        }
    }

    public static enum ConversionMessageType {
        INFO,
        WARNING,
        ERROR;

    }
}

