/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.util;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.util.PercentageCalculator;

public class PercentageBar
extends Composite
implements HasValue<Integer> {
    public static final String FAILURE = "#CC0000";
    public static final String COMPLETE_SUCCESS = "GREEN";
    public static final String INCOMPLETE = "YELLOW";
    private static PercentageBarBinder uiBinder = (PercentageBarBinder)GWT.create(PercentageBarBinder.class);
    @UiField
    Label percentage;
    @UiField
    DivElement wrapper;
    @UiField
    DivElement text;
    @UiField
    DivElement bar;
    private int percent = 0;
    private String inCompleteBarColor = "#CC0000";

    public PercentageBar() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public PercentageBar(String color, int width, float percent) {
        this();
        this.setColor(color);
        this.setWidth(width);
        this.setPercent((int)percent);
    }

    public PercentageBar(String color, int width, int numerator, int denominator) {
        this(color, width, PercentageCalculator.calculatePercent(numerator, denominator));
    }

    private void setColor(String color) {
        this.bar.getStyle().setBackgroundColor(color);
    }

    public void setBackgroundColor(String color) {
        this.wrapper.getStyle().setBackgroundColor(color);
    }

    public void setWidth(String width) {
        this.setWidth(Integer.parseInt(width));
    }

    public void setWidth(int width) {
        this.text.getStyle().setWidth((double)width, Style.Unit.PX);
        this.wrapper.getStyle().setWidth((double)width, Style.Unit.PX);
    }

    public void setPercent(int percent) {
        this.setValue(percent);
    }

    public void setPercent(int numerator, int denominator) {
        this.setPercent(PercentageCalculator.calculatePercent(numerator, denominator));
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Integer> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public Integer getValue() {
        return this.percent;
    }

    public void setValue(Integer value) {
        this.setValue(value, false);
    }

    public void setValue(Integer value, boolean fireEvents) {
        this.percent = value;
        this.setColor();
        this.percentage.setText(Integer.toString(value) + " %");
        this.bar.getStyle().setWidth((double)value.intValue(), Style.Unit.PCT);
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    private void setColor() {
        if (this.percent < 100) {
            this.setColor(this.inCompleteBarColor);
        } else {
            this.setColor(COMPLETE_SUCCESS);
        }
    }

    public void setInCompleteBarColor(String color) {
        this.inCompleteBarColor = color;
    }

    static interface PercentageBarBinder
    extends UiBinder<Widget, PercentageBar> {
    }
}

