/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.client.rpc.SecurityService;
import org.drools.guvnor.client.rpc.UserSecurityContext;
import org.drools.guvnor.server.security.SecurityServiceImpl;
import org.drools.guvnor.server.util.LoggingHelper;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.solder.core.Veto;

@Veto
public class SecurityServiceServlet
extends RemoteServiceServlet
implements SecurityService {
    private static final LoggingHelper log = LoggingHelper.getLogger(SecurityServiceServlet.class);
    @Inject
    private SecurityServiceImpl securityService;

    protected void doUnexpectedFailure(Throwable e) {
        if (e.getCause() instanceof AuthorizationException) {
            log.info(e.getMessage(), e);
            HttpServletResponse response = this.getThreadLocalResponse();
            try {
                response.setContentType("text/plain");
                response.setStatus(401);
                response.getWriter().write(e.getCause().getMessage());
            }
            catch (IOException ex) {
                this.getServletContext().log("respondWithUnexpectedFailure failed while sending the previous failure to the client", (Throwable)ex);
            }
        } else {
            log.error(e.getMessage(), e.getCause());
            super.doUnexpectedFailure(e);
        }
    }

    @Override
    public UserSecurityContext getCurrentUser() {
        if (this.securityService == null) {
            throw new IllegalStateException("CDI hasn't been properly started.\n  Make sure your IDE classpath is in sync with the real maven classpath.\n  The classpath should include weld-servlet.");
        }
        return this.securityService.getCurrentUser();
    }

    @Override
    public List<Capability> getUserCapabilities() {
        return this.securityService.getUserCapabilities();
    }

    @Override
    public boolean login(String userName, String password) {
        return this.securityService.login(userName, password);
    }

    @Override
    public void logout() {
        this.securityService.logout();
    }
}

