/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.apache.sis.internal.jaxb.gml.CodeType;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.DefaultMemberName;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.ScopedName;
import org.opengis.util.TypeName;

abstract class NameAdapter<ValueType extends NameAdapter<ValueType, BoundType>, BoundType extends GenericName>
extends XmlAdapter<ValueType, BoundType> {
    GenericName name;

    NameAdapter() {
    }

    private void ensureUndefined() throws IllegalStateException {
        if (this.name != null) {
            throw new IllegalStateException(Errors.format((short)131, "name"));
        }
    }

    @XmlElementRef
    public final CodeType getCodeType() {
        CodeType codeType;
        GenericName genericName = this.name;
        if (genericName instanceof LocalName) {
            if (genericName instanceof TypeName || genericName instanceof MemberName) {
                return null;
            }
            codeType = new CodeType.LocalName();
        } else if (genericName instanceof ScopedName) {
            codeType = new CodeType.ScopedName();
        } else {
            return null;
        }
        codeType.setName(genericName);
        return codeType;
    }

    public final void setCodeType(CodeType codeType) throws IllegalStateException {
        this.ensureUndefined();
        if (codeType != null) {
            this.name = codeType.getName();
        }
    }

    @XmlElementRef
    public final DefaultLocalName getNameType() {
        GenericName genericName = this.name;
        if (genericName instanceof TypeName) {
            return DefaultTypeName.castOrCopy((TypeName)genericName);
        }
        if (genericName instanceof MemberName) {
            return DefaultMemberName.castOrCopy((MemberName)genericName);
        }
        return null;
    }

    public final void setNameType(DefaultLocalName defaultLocalName) throws IllegalStateException {
        this.ensureUndefined();
        this.name = defaultLocalName;
    }
}

