/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gml;

import java.net.URISyntaxException;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.measure.Units;
import org.apache.sis.util.resources.Errors;

@XmlType(name="MeasureType")
public final class Measure {
    @XmlValue
    public double value;
    public Unit<?> unit;
    public boolean asXPointer;

    public Measure() {
        this.value = Double.NaN;
    }

    public Measure(double d, Unit<?> unit) {
        this.value = d;
        this.unit = unit;
    }

    @XmlAttribute(name="uom", required=true)
    public String getUOM() {
        return Measure.getUOM(this.unit, this.asXPointer, false);
    }

    public static String getUOM(Unit<?> unit, boolean bl, boolean bl2) {
        Integer n;
        if (!bl && (n = Units.getEpsgCode(unit, bl2)) != null) {
            return "urn:ogc:def:uom:EPSG::" + n;
        }
        if (unit == null || unit.equals(Unit.ONE)) {
            return "";
        }
        if (unit.equals(NonSI.PIXEL)) {
            return "pixel";
        }
        return Context.schema(Context.current(), "gmd", "http://schemas.opengis.net/iso/19139/20070417/").append("resources/uom/gmxUom.xml").append("#xpointer(//*[@gml:id='").append(unit).append("'])").toString();
    }

    public void setUOM(String string) throws URISyntaxException {
        Context context = Context.current();
        this.unit = Context.converter(context).toUnit(context, string);
    }

    public <Q extends Quantity> Unit<Q> getUnit(Class<Q> clazz) {
        return this.unit != null ? this.unit.asType(clazz) : null;
    }

    public boolean setUnit(Unit<?> unit) {
        boolean bl = this.unit != null && !this.unit.equals(unit);
        this.unit = unit;
        return bl;
    }

    public static void missingUOM(Class<?> clazz, String string) {
        Context.warningOccured(Context.current(), clazz, string, Errors.class, (short)55, "uom", "Measure");
    }
}

