/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import org.apache.sis.internal.system.DaemonThread;
import org.apache.sis.internal.system.DelayedRunnable;
import org.apache.sis.internal.system.Threads;
import org.apache.sis.util.logging.Logging;

public final class DelayedExecutor
extends DaemonThread {
    private static final BlockingQueue<DelayedRunnable> QUEUE = new DelayQueue<DelayedRunnable>();

    public static void executeDaemonTask(DelayedRunnable delayedRunnable) {
        QUEUE.add(delayedRunnable);
    }

    public static void schedule(DelayedRunnable delayedRunnable) {
        QUEUE.add(delayedRunnable);
    }

    private DelayedExecutor(DaemonThread daemonThread) {
        super("DelayedExecutor", daemonThread);
        this.setPriority(6);
    }

    @Override
    public final void run() {
        BlockingQueue<DelayedRunnable> blockingQueue;
        while ((blockingQueue = QUEUE) != null) {
            try {
                DelayedRunnable delayedRunnable = blockingQueue.take();
                if (delayedRunnable != null) {
                    delayedRunnable.run();
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                Logging.unexpectedException(Logging.getLogger("org.apache.sis.system"), this.getClass(), "run", throwable);
            }
            if (!this.isKillRequested()) continue;
            blockingQueue.clear();
            break;
        }
    }

    @Override
    protected boolean isStalled() {
        DelayedRunnable delayedRunnable = (DelayedRunnable)QUEUE.peek();
        if (delayedRunnable != null && delayedRunnable.getDelay(TimeUnit.NANOSECONDS) <= 0L) {
            try {
                for (int i = 0; i < 50 && this.isAlive(); ++i) {
                    Thread.sleep(100L);
                    if (QUEUE.peek() == delayedRunnable) continue;
                    return false;
                }
                return true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<Threads> clazz = Threads.class;
        synchronized (Threads.class) {
            DelayedExecutor delayedExecutor = new DelayedExecutor(Threads.lastCreatedDaemon);
            Threads.lastCreatedDaemon = delayedExecutor;
            delayedExecutor.start();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

