/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io;

import java.io.CharConversionException;
import java.io.IOException;
import org.apache.sis.internal.jdk7.JDK7;
import org.apache.sis.io.IO;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Characters;

abstract class Appender
implements Appendable {
    protected final Appendable out;
    private char highSurrogate;

    protected Appender(Appendable appendable) {
        ArgumentChecks.ensureNonNull("out", appendable);
        this.out = appendable;
    }

    final String lineSeparator(CharSequence charSequence, int n, int n2) {
        if (this.isHighSurrogate()) {
            ++n;
        }
        while (n < n2) {
            int n3 = Character.codePointAt(charSequence, n);
            int n4 = n;
            n += Character.charCount(n3);
            if (!Characters.isLineOrParagraphSeparator(n3)) continue;
            if (n3 == 13 && n < n2 && charSequence.charAt(n) == '\n') {
                ++n;
            }
            return charSequence.subSequence(n4, n).toString();
        }
        return null;
    }

    final int toCodePoint(char c) {
        char c2 = this.highSurrogate;
        if (c2 != '\u0000') {
            this.highSurrogate = '\u0000';
            if (Character.isLowSurrogate(c)) {
                return Character.toCodePoint(c2, c);
            }
        }
        if (Character.isHighSurrogate(c)) {
            this.highSurrogate = c;
            return -1;
        }
        return c;
    }

    final boolean isHighSurrogate() {
        return this.highSurrogate != '\u0000';
    }

    final int appendSurrogate(CharSequence charSequence, int n, int n2) throws IOException {
        if (n != n2 && this.highSurrogate != '\u0000') {
            char c = charSequence.charAt(n);
            if (Character.isLowSurrogate(c)) {
                this.append(c);
                ++n;
            } else {
                throw new CharConversionException();
            }
        }
        return n;
    }

    final void appendCodePoint(int n) throws IOException {
        if (JDK7.isBmpCodePoint(n)) {
            this.out.append((char)n);
        } else if (Character.isSupplementaryCodePoint(n)) {
            this.out.append(JDK7.highSurrogate(n)).append(JDK7.lowSurrogate(n));
        } else {
            throw new CharConversionException();
        }
    }

    @Override
    public Appendable append(CharSequence charSequence) throws IOException {
        if (charSequence == null) {
            charSequence = "null";
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    public String toString() {
        return IO.toString(this);
    }
}

