/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.commons.regex.util;

import org.uberfire.commons.validation.PortablePreconditions;

public final class GlobToRegEx {
    private GlobToRegEx() {
    }

    public static String globToRegex(String glob) {
        PortablePreconditions.checkNotNull("glob", glob);
        boolean inCharSet = false;
        StringBuilder buffer = new StringBuilder(2 * glob.length());
        char[] pattern = glob.toCharArray();
        block11: for (int ch = 0; ch < pattern.length; ++ch) {
            switch (pattern[ch]) {
                case '*': {
                    if (inCharSet) {
                        buffer.append('*');
                        continue block11;
                    }
                    buffer.append(".*");
                    continue block11;
                }
                case '?': {
                    if (inCharSet) {
                        buffer.append('?');
                        continue block11;
                    }
                    buffer.append(".?");
                    continue block11;
                }
                case '[': {
                    inCharSet = true;
                    buffer.append(pattern[ch]);
                    if (ch + 1 >= pattern.length) continue block11;
                    switch (pattern[ch + 1]) {
                        case '!': 
                        case '^': {
                            buffer.append('^');
                            ++ch;
                            continue block11;
                        }
                        case ']': {
                            buffer.append(']');
                            ++ch;
                            continue block11;
                        }
                    }
                    continue block11;
                }
                case ']': {
                    inCharSet = false;
                    buffer.append(pattern[ch]);
                    continue block11;
                }
                case '\\': {
                    buffer.append('\\');
                    if (ch == pattern.length - 1) {
                        buffer.append('\\');
                        continue block11;
                    }
                    if (GlobToRegEx.__isGlobMetaCharacter(pattern[ch + 1])) {
                        buffer.append(pattern[++ch]);
                        continue block11;
                    }
                    buffer.append('\\');
                    continue block11;
                }
                default: {
                    if (!inCharSet && GlobToRegEx.__isRegExMetaCharacter(pattern[ch])) {
                        buffer.append('\\');
                    }
                    buffer.append(pattern[ch]);
                }
            }
        }
        return buffer.toString();
    }

    private static boolean __isRegExMetaCharacter(char ch) {
        return "'*?+[]()|^$.{}\\".indexOf(ch) >= 0;
    }

    private static boolean __isGlobMetaCharacter(char ch) {
        return "*?[]".indexOf(ch) >= 0;
    }
}

