/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.tika.config.Field;
import org.apache.tika.parser.pdf.AccessChecker;
import org.apache.tika.parser.pdf.PDF2XHTML;

public class PDFParserConfig
implements Serializable {
    private static final long serialVersionUID = 6492570218190936986L;
    private boolean enableAutoSpace = true;
    private boolean suppressDuplicateOverlappingText;
    private boolean extractAnnotationText = true;
    @Field
    private boolean sortByPosition = false;
    private boolean extractAcroFormContent = true;
    private boolean extractInlineImages = false;
    private boolean extractUniqueInlineImagesOnly = true;
    private Float averageCharTolerance;
    private Float spacingTolerance;
    private boolean ifXFAExtractOnlyXFA = false;
    private OCR_STRATEGY ocrStrategy = OCR_STRATEGY.NO_OCR;
    private int ocrDPI = 200;
    private ImageType ocrImageType = ImageType.GRAY;
    private String ocrImageFormatName = "png";
    private AccessChecker accessChecker;
    private boolean isCatchIntermediateIOExceptions = true;

    public PDFParserConfig() {
        this.init(this.getClass().getResourceAsStream("PDFParser.properties"));
    }

    public PDFParserConfig(InputStream is) {
        this.init(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream is) {
        if (is == null) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException iOException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.setEnableAutoSpace(this.getBooleanProp(props.getProperty("enableAutoSpace"), this.getEnableAutoSpace()));
        this.setSuppressDuplicateOverlappingText(this.getBooleanProp(props.getProperty("suppressDuplicateOverlappingText"), this.getSuppressDuplicateOverlappingText()));
        this.setExtractAnnotationText(this.getBooleanProp(props.getProperty("extractAnnotationText"), this.getExtractAnnotationText()));
        this.setSortByPosition(this.getBooleanProp(props.getProperty("sortByPosition"), this.getSortByPosition()));
        this.setExtractAcroFormContent(this.getBooleanProp(props.getProperty("extractAcroFormContent"), this.getExtractAcroFormContent()));
        this.setExtractInlineImages(this.getBooleanProp(props.getProperty("extractInlineImages"), this.getExtractInlineImages()));
        this.setExtractUniqueInlineImagesOnly(this.getBooleanProp(props.getProperty("extractUniqueInlineImagesOnly"), this.getExtractUniqueInlineImagesOnly()));
        this.setIfXFAExtractOnlyXFA(this.getBooleanProp(props.getProperty("ifXFAExtractOnlyXFA"), this.getIfXFAExtractOnlyXFA()));
        this.setCatchIntermediateIOExceptions(this.getBooleanProp(props.getProperty("catchIntermediateIOExceptions"), this.isCatchIntermediateIOExceptions()));
        this.setOcrStrategy(OCR_STRATEGY.parse(props.getProperty("ocrStrategy")));
        this.setOcrDPI(this.getIntProp(props.getProperty("ocrDPI"), this.getOcrDPI()));
        this.setOcrImageFormatName(props.getProperty("ocrImageFormatName"));
        this.setOcrImageType(this.parseImageType(props.getProperty("ocrImageType")));
        boolean checkExtractAccessPermission = this.getBooleanProp(props.getProperty("checkExtractAccessPermission"), false);
        boolean allowExtractionForAccessibility = this.getBooleanProp(props.getProperty("allowExtractionForAccessibility"), true);
        this.accessChecker = !checkExtractAccessPermission ? new AccessChecker() : new AccessChecker(allowExtractionForAccessibility);
    }

    public void configure(PDF2XHTML pdf2XHTML) {
        pdf2XHTML.setSortByPosition(this.getSortByPosition());
        if (this.getEnableAutoSpace()) {
            pdf2XHTML.setWordSeparator(" ");
        } else {
            pdf2XHTML.setWordSeparator("");
        }
        if (this.getAverageCharTolerance() != null) {
            pdf2XHTML.setAverageCharTolerance(this.getAverageCharTolerance().floatValue());
        }
        if (this.getSpacingTolerance() != null) {
            pdf2XHTML.setSpacingTolerance(this.getSpacingTolerance().floatValue());
        }
        pdf2XHTML.setSuppressDuplicateOverlappingText(this.getSuppressDuplicateOverlappingText());
    }

    public boolean getExtractAcroFormContent() {
        return this.extractAcroFormContent;
    }

    public void setExtractAcroFormContent(boolean extractAcroFormContent) {
        this.extractAcroFormContent = extractAcroFormContent;
    }

    public boolean getIfXFAExtractOnlyXFA() {
        return this.ifXFAExtractOnlyXFA;
    }

    public void setIfXFAExtractOnlyXFA(boolean ifXFAExtractOnlyXFA) {
        this.ifXFAExtractOnlyXFA = ifXFAExtractOnlyXFA;
    }

    public boolean getExtractInlineImages() {
        return this.extractInlineImages;
    }

    public void setExtractInlineImages(boolean extractInlineImages) {
        this.extractInlineImages = extractInlineImages;
    }

    public boolean getExtractUniqueInlineImagesOnly() {
        return this.extractUniqueInlineImagesOnly;
    }

    public void setExtractUniqueInlineImagesOnly(boolean extractUniqueInlineImagesOnly) {
        this.extractUniqueInlineImagesOnly = extractUniqueInlineImagesOnly;
    }

    public boolean getEnableAutoSpace() {
        return this.enableAutoSpace;
    }

    public void setEnableAutoSpace(boolean enableAutoSpace) {
        this.enableAutoSpace = enableAutoSpace;
    }

    public boolean getSuppressDuplicateOverlappingText() {
        return this.suppressDuplicateOverlappingText;
    }

    public void setSuppressDuplicateOverlappingText(boolean suppressDuplicateOverlappingText) {
        this.suppressDuplicateOverlappingText = suppressDuplicateOverlappingText;
    }

    public boolean getExtractAnnotationText() {
        return this.extractAnnotationText;
    }

    public void setExtractAnnotationText(boolean extractAnnotationText) {
        this.extractAnnotationText = extractAnnotationText;
    }

    public boolean getSortByPosition() {
        return this.sortByPosition;
    }

    public void setSortByPosition(boolean sortByPosition) {
        this.sortByPosition = sortByPosition;
    }

    public Float getAverageCharTolerance() {
        return this.averageCharTolerance;
    }

    public void setAverageCharTolerance(Float averageCharTolerance) {
        this.averageCharTolerance = averageCharTolerance;
    }

    public Float getSpacingTolerance() {
        return this.spacingTolerance;
    }

    public void setSpacingTolerance(Float spacingTolerance) {
        this.spacingTolerance = spacingTolerance;
    }

    public AccessChecker getAccessChecker() {
        return this.accessChecker;
    }

    public void setAccessChecker(AccessChecker accessChecker) {
        this.accessChecker = accessChecker;
    }

    public boolean isCatchIntermediateIOExceptions() {
        return this.isCatchIntermediateIOExceptions;
    }

    public void setCatchIntermediateIOExceptions(boolean catchIntermediateIOExceptions) {
        this.isCatchIntermediateIOExceptions = catchIntermediateIOExceptions;
    }

    public void setOcrStrategy(OCR_STRATEGY ocrStrategy) {
        this.ocrStrategy = ocrStrategy;
    }

    public void setOcrStrategy(String ocrStrategyString) {
        this.ocrStrategy = OCR_STRATEGY.parse(ocrStrategyString);
    }

    public OCR_STRATEGY getOcrStrategy() {
        return this.ocrStrategy;
    }

    private boolean getBooleanProp(String p, boolean defaultMissing) {
        if (p == null) {
            return defaultMissing;
        }
        if (p.toLowerCase(Locale.ROOT).equals("true")) {
            return true;
        }
        if (p.toLowerCase(Locale.ROOT).equals("false")) {
            return false;
        }
        return defaultMissing;
    }

    private int getIntProp(String p, int defaultMissing) {
        if (p == null) {
            return defaultMissing;
        }
        return Integer.parseInt(p);
    }

    public String getOcrImageFormatName() {
        return this.ocrImageFormatName;
    }

    public void setOcrImageFormatName(String ocrImageFormatName) {
        this.ocrImageFormatName = ocrImageFormatName;
    }

    public ImageType getOcrImageType() {
        return this.ocrImageType;
    }

    public void setOcrImageType(ImageType ocrImageType) {
        this.ocrImageType = ocrImageType;
    }

    public void setOcrImageType(String ocrImageTypeString) {
        this.ocrImageType = this.parseImageType(ocrImageTypeString);
    }

    public int getOcrDPI() {
        return this.ocrDPI;
    }

    public void setOcrDPI(int ocrDPI) {
        this.ocrDPI = ocrDPI;
    }

    private ImageType parseImageType(String ocrImageType) {
        for (ImageType t : ImageType.values()) {
            if (!ocrImageType.equalsIgnoreCase(t.toString())) continue;
            return t;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("I regret that I could not parse '");
        sb.append(ocrImageType);
        sb.append("'. I'm only familiar with: ");
        int i = 0;
        for (ImageType t : ImageType.values()) {
            if (i++ == 0) {
                sb.append(", ");
            }
            sb.append(t.toString());
        }
        throw new IllegalArgumentException(sb.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PDFParserConfig)) {
            return false;
        }
        PDFParserConfig config = (PDFParserConfig)o;
        if (this.getEnableAutoSpace() != config.getEnableAutoSpace()) {
            return false;
        }
        if (this.getSuppressDuplicateOverlappingText() != config.getSuppressDuplicateOverlappingText()) {
            return false;
        }
        if (this.getExtractAnnotationText() != config.getExtractAnnotationText()) {
            return false;
        }
        if (this.getSortByPosition() != config.getSortByPosition()) {
            return false;
        }
        if (this.getExtractAcroFormContent() != config.getExtractAcroFormContent()) {
            return false;
        }
        if (this.getExtractInlineImages() != config.getExtractInlineImages()) {
            return false;
        }
        if (this.getExtractUniqueInlineImagesOnly() != config.getExtractUniqueInlineImagesOnly()) {
            return false;
        }
        if (this.getIfXFAExtractOnlyXFA() != config.getIfXFAExtractOnlyXFA()) {
            return false;
        }
        if (this.getOcrDPI() != config.getOcrDPI()) {
            return false;
        }
        if (this.isCatchIntermediateIOExceptions() != config.isCatchIntermediateIOExceptions()) {
            return false;
        }
        if (!this.getAverageCharTolerance().equals(config.getAverageCharTolerance())) {
            return false;
        }
        if (!this.getSpacingTolerance().equals(config.getSpacingTolerance())) {
            return false;
        }
        if (!this.getOcrStrategy().equals((Object)config.getOcrStrategy())) {
            return false;
        }
        if (this.getOcrImageType() != config.getOcrImageType()) {
            return false;
        }
        if (!this.getOcrImageFormatName().equals(config.getOcrImageFormatName())) {
            return false;
        }
        return this.getAccessChecker().equals(config.getAccessChecker());
    }

    public int hashCode() {
        int result = this.getEnableAutoSpace() ? 1 : 0;
        result = 31 * result + (this.getSuppressDuplicateOverlappingText() ? 1 : 0);
        result = 31 * result + (this.getExtractAnnotationText() ? 1 : 0);
        result = 31 * result + (this.getSortByPosition() ? 1 : 0);
        result = 31 * result + (this.getExtractAcroFormContent() ? 1 : 0);
        result = 31 * result + (this.getExtractInlineImages() ? 1 : 0);
        result = 31 * result + (this.getExtractUniqueInlineImagesOnly() ? 1 : 0);
        result = 31 * result + this.getAverageCharTolerance().hashCode();
        result = 31 * result + this.getSpacingTolerance().hashCode();
        result = 31 * result + (this.getIfXFAExtractOnlyXFA() ? 1 : 0);
        result = 31 * result + this.ocrStrategy.hashCode();
        result = 31 * result + this.getOcrDPI();
        result = 31 * result + this.getOcrImageType().hashCode();
        result = 31 * result + this.getOcrImageFormatName().hashCode();
        result = 31 * result + this.getAccessChecker().hashCode();
        result = 31 * result + (this.isCatchIntermediateIOExceptions() ? 1 : 0);
        return result;
    }

    public String toString() {
        return "PDFParserConfig{enableAutoSpace=" + this.enableAutoSpace + ", suppressDuplicateOverlappingText=" + this.suppressDuplicateOverlappingText + ", extractAnnotationText=" + this.extractAnnotationText + ", sortByPosition=" + this.sortByPosition + ", extractAcroFormContent=" + this.extractAcroFormContent + ", extractInlineImages=" + this.extractInlineImages + ", extractUniqueInlineImagesOnly=" + this.extractUniqueInlineImagesOnly + ", averageCharTolerance=" + this.averageCharTolerance + ", spacingTolerance=" + this.spacingTolerance + ", ifXFAExtractOnlyXFA=" + this.ifXFAExtractOnlyXFA + ", ocrStrategy=" + (Object)((Object)this.ocrStrategy) + ", ocrDPI=" + this.ocrDPI + ", ocrImageType=" + this.ocrImageType + ", ocrImageFormatName='" + this.ocrImageFormatName + '\'' + ", accessChecker=" + this.accessChecker + ", isCatchIntermediateIOExceptions=" + this.isCatchIntermediateIOExceptions + '}';
    }

    public static enum OCR_STRATEGY {
        NO_OCR,
        OCR_ONLY,
        OCR_AND_TEXT_EXTRACTION;


        private static OCR_STRATEGY parse(String s) {
            if (s == null) {
                return NO_OCR;
            }
            if ("no_ocr".equals(s.toLowerCase(Locale.ROOT))) {
                return NO_OCR;
            }
            if ("ocr_only".equals(s.toLowerCase(Locale.ROOT))) {
                return OCR_ONLY;
            }
            if (s.toLowerCase(Locale.ROOT).contains("ocr_and_text")) {
                return OCR_AND_TEXT_EXTRACTION;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("I regret that I don't recognize '").append(s);
            sb.append("' as an OCR_STRATEGY. I only recognize:");
            int i = 0;
            for (OCR_STRATEGY strategy : OCR_STRATEGY.values()) {
                if (i++ > 0) {
                    sb.append(", ");
                }
                sb.append(strategy.toString());
            }
            throw new IllegalArgumentException(sb.toString());
        }
    }
}

