/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.ala.pipeline;

import java.util.ArrayList;
import java.util.List;
import org.guvnor.ala.config.Config;
import org.guvnor.ala.pipeline.BasePipeline;
import org.guvnor.ala.pipeline.Pipeline;
import org.guvnor.ala.pipeline.PipelineBuilder;
import org.guvnor.ala.pipeline.PipelineConfig;
import org.guvnor.ala.pipeline.Stage;
import org.guvnor.ala.pipeline.StageUtil;

public final class PipelineFactory {
    private PipelineFactory() {
    }

    public static <INPUT extends Config, OUTPUT extends Config> PipelineBuilder<INPUT, OUTPUT> startFrom(final Stage<INPUT, OUTPUT> stage) {
        return new PipelineBuilder<INPUT, OUTPUT>(){
            private final List<Stage> stages = new ArrayList<Stage>();
            {
                this.stages.add(stage);
            }

            @Override
            public <T extends Config> PipelineBuilder<INPUT, T> andThen(Stage<? super OUTPUT, T> nextStep) {
                this.stages.add(nextStep);
                return this;
            }

            @Override
            public Pipeline buildAs(String name) {
                return new BasePipeline(name, this.stages);
            }

            @Override
            public Pipeline build(PipelineConfig config) {
                this.stages.clear();
                for (Config c : config.getConfigStages()) {
                    this.stages.add(StageUtil.config(c.toString(), f -> c));
                }
                return new BasePipeline(config.getName(), this.stages, config);
            }
        };
    }
}

