/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.cells;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.decisiontable.cells.AbstractPopupEditCell;

public class PopupDialectDropDownEditCell
extends AbstractPopupEditCell<String, String> {
    private static String[] DIALECTS = new String[]{"java", "mvel"};
    private final ListBox listBox = new ListBox();

    public PopupDialectDropDownEditCell(boolean isReadOnly) {
        super(isReadOnly);
        this.setItems(DIALECTS);
        this.listBox.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                boolean keyEnter;
                boolean keyTab = event.getNativeKeyCode() == 9;
                boolean bl = keyEnter = event.getNativeKeyCode() == 13;
                if (keyEnter || keyTab) {
                    PopupDialectDropDownEditCell.this.commit();
                }
            }
        });
        this.vPanel.add((Widget)this.listBox);
    }

    public void render(Cell.Context context, String value, SafeHtmlBuilder sb) {
        if (value != null) {
            sb.append(this.renderer.render((Object)value));
        }
    }

    private void setItems(String[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.listBox.addItem(items[i]);
        }
    }

    @Override
    protected void commit() {
        String value = null;
        int selectedIndex = this.listBox.getSelectedIndex();
        if (selectedIndex >= 0) {
            value = this.listBox.getValue(selectedIndex);
        }
        this.setValue(this.lastContext, this.lastParent, value);
        if (this.valueUpdater != null) {
            this.valueUpdater.update((Object)value);
        }
        this.panel.hide();
    }

    @Override
    protected void startEditing(Cell.Context context, final Element parent, String value) {
        boolean emptyValue;
        boolean bl = emptyValue = value == null;
        if (emptyValue) {
            this.listBox.setSelectedIndex(0);
        } else {
            for (int i = 0; i < this.listBox.getItemCount(); ++i) {
                if (!this.listBox.getValue(i).equals(value)) continue;
                this.listBox.setSelectedIndex(i);
                break;
            }
        }
        this.panel.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

            public void setPosition(int offsetWidth, int offsetHeight) {
                PopupDialectDropDownEditCell.this.panel.setPopupPosition(parent.getAbsoluteLeft() + PopupDialectDropDownEditCell.this.offsetX, parent.getAbsoluteTop() + PopupDialectDropDownEditCell.this.offsetY);
                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                    public void execute() {
                        PopupDialectDropDownEditCell.this.listBox.setFocus(true);
                    }
                });
            }
        });
    }
}

