/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.moduleeditor.drools;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.RefreshModuleDataModelEvent;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.SuggestionCompletionEngineService;
import org.drools.guvnor.client.rpc.SuggestionCompletionEngineServiceAsync;
import org.drools.ide.common.client.modeldriven.FactTypeFilter;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;

public class SuggestionCompletionCache
implements RefreshModuleDataModelEvent.Handler {
    private static SuggestionCompletionCache INSTANCE = null;
    Map<String, SuggestionCompletionEngine> cache = new HashMap<String, SuggestionCompletionEngine>();
    Map<String, FactTypeFilter> filters = new HashMap<String, FactTypeFilter>();

    public static SuggestionCompletionCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SuggestionCompletionCache();
        }
        return INSTANCE;
    }

    public void setEventBus(EventBus eventBus) {
        eventBus.addHandler(RefreshModuleDataModelEvent.TYPE, (EventHandler)this);
    }

    public void onRefreshModuleDataModel(RefreshModuleDataModelEvent refreshModuleDataModelEvent) {
        this.loadPackage(refreshModuleDataModelEvent.getModuleName(), refreshModuleDataModelEvent.getCallbackCommand());
    }

    public SuggestionCompletionEngine getEngineFromCache(String packageName) {
        SuggestionCompletionEngine eng = this.cache.get(packageName);
        if (eng == null) {
            ErrorPopup.showMessage((String)Constants.INSTANCE.UnableToGetContentAssistanceForThisRule());
            return null;
        }
        return eng;
    }

    public void refreshPackage(final String packageName, final Command done) {
        LoadingPopup.showMessage((String)Constants.INSTANCE.InitialisingInfoFor0PleaseWait(packageName));
        this.filters.remove(packageName);
        SuggestionCompletionEngineServiceAsync suggestionCompletionEngineService = (SuggestionCompletionEngineServiceAsync)GWT.create(SuggestionCompletionEngineService.class);
        suggestionCompletionEngineService.loadSuggestionCompletionEngine(packageName, (AsyncCallback<SuggestionCompletionEngine>)new GenericCallback<SuggestionCompletionEngine>(){

            public void onSuccess(SuggestionCompletionEngine engine) {
                SuggestionCompletionCache.this.cache.put(packageName, engine);
                done.execute();
            }

            public void onFailure(Throwable t) {
                LoadingPopup.close();
                ErrorPopup.showMessage((String)Constants.INSTANCE.UnableToValidatePackageForSCE(packageName));
                done.execute();
            }
        });
    }

    public void loadPackage(final String packageName, final Command done) {
        final FactTypeFilter filter = this.filters.get(packageName);
        this.refreshPackage(packageName, new Command(){

            public void execute() {
                if (filter != null) {
                    SuggestionCompletionCache.this.filters.put(packageName, filter);
                    SuggestionCompletionCache.this.getEngineFromCache(packageName).setFactTypeFilter(filter);
                }
                if (done != null) {
                    done.execute();
                }
            }
        });
    }

    public void applyFactFilter(String packageName, FactTypeFilter filter, Command done) {
        this.filters.put(packageName, filter);
        this.loadPackage(packageName, done);
    }
}

